package com.liquidnet.service.merchant.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;

import java.time.LocalDateTime;

public class MerchantPermissionVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -1693974333583118507L;

    @ApiModelProperty(value = "permission_id", example = "1")
    private String permissionId;

    @ApiModelProperty(value = "名称")
    private String name;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;


    private static final MerchantPermissionVo obj = new MerchantPermissionVo();

    public static MerchantPermissionVo getNew() {
        try {
            return (MerchantPermissionVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new MerchantPermissionVo();
    }
}
