package com.liquidnet.common.cache.redis.config;

import lombok.var;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;

public class RedisStreamConfig {
    private String hostname;
    {
        try {
            hostname = InetAddress.getLocalHost().getHostName() + "_";
        } catch (UnknownHostException ignored) {
            hostname = "";
        }
    }

    public StreamMessageListenerContainer<String, MapRecord<String, String, String>> buildStreamMessageListenerContainer(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        return StreamMessageListenerContainer.create(factory, options);
    }

    public String getConsumerName(String consumerSeqname) {
        return hostname.concat(consumerSeqname);
    }
}
