package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerKylinSmsNoticeRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

@Configuration
public class ConsumerKylinSmsSenderRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerKylinSmsNoticeRdsReceiver consumerKylinSmsNoticeRdsReceiver;

    /**
     * 短信通知
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveSqlURegister(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.AdamQueue.SMS_NOTICE.getGroup(), getConsumerName(MQConst.AdamQueue.SMS_NOTICE.name() + t)),
                StreamOffset.create(MQConst.AdamQueue.SMS_NOTICE.getKey(), ReadOffset.lastConsumed()), consumerKylinSmsNoticeRdsReceiver);
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 短信通知 */

    @Bean
    public Subscription subscriptionSmsNotice0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlURegister(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSmsNotice1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlURegister(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSmsNotice2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlURegister(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSmsNotice3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlURegister(listenerContainer, 3);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSmsNotice4(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlURegister(listenerContainer, 4);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSmsNotice5(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlURegister(listenerContainer, 5);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSmsNotice6(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlURegister(listenerContainer, 6);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSmsNotice7(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlURegister(listenerContainer, 7);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSmsNotice8(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlURegister(listenerContainer, 8);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSmsNotice9(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlURegister(listenerContainer, 9);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */
}
