package com.liquidnet.service.goblin.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.PageReadListener;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.IGoblinImportService;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreOrderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.HashMap;

@Service
@Slf4j
public class GoblinImportServiceImpl implements IGoblinImportService {

    @Autowired
    private IGoblinStoreOrderService iGoblinStoreOrderService;

    @Override
    public ResponseDto<String> importExpress(MultipartFile file) {
        if (file == null) {
            return ResponseDto.failure();
        }
        try {
            EasyExcel.read(file.getInputStream(), new PageReadListener<HashMap<String, String>>(dataList -> {
                for (HashMap<String, String> item : dataList) {
                    String skuIds = "";
                    int init = 22;
                    int skip = 9;
                    int count = 1+(item.size() - init) / skip;
                    String orderId = item.get(0);
                    String mailNo = item.get(13);
                    for (int i = 0; i < count; i++) {
                        String skuId = item.get(init + (i * skip));
                        if (skuId != null && !skuId.equals("null")) {
                            skuIds = skuIds.concat(skuId).concat(",");
                        }
                    }
                    if (skuIds.trim().length() > 0) {
                        skuIds = skuIds.substring(0, skuIds.trim().length() - 1);
                    }
                    log.debug("orderId = " + orderId);
                    log.debug("skuIds = " + skuIds);
                    log.debug("mailNo = " + mailNo);
                    if (mailNo == null || mailNo.equals("")) {
                        log.error("发货失败 orderId = " + orderId + "skuIds = " + skuIds + " 快递单号空");
                    }
                    ResponseDto<Boolean> express = iGoblinStoreOrderService.express(orderId, skuIds, mailNo, CurrentUtil.getCurrentUid(),"");
                    if (express.getCode().equals("0")) {
                    } else {
                        log.error("发货失败 orderId = " + orderId + "skuIds = " + skuIds + " mailNo = " + mailNo);
                    }
                }
            })).sheet().doRead();
//            if (StringUtils.isNull(mallOrdertVoList) || mallOrdertVoList.size() == 0) {
//                throw new BusinessException("导入数据不能为空！");
//            }
//            int successNum = 0;
//            int failureNum = 0;
//            StringBuilder successMsg = new StringBuilder();
//            StringBuilder failureMsg = new StringBuilder();
//            for (OrderMallOrderVo mallOrderVo : mallOrdertVoList) {
//                log.debug("data = " + mallOrderVo.toString());
////            ResponseDto<Boolean> express = iGoblinStoreOrderService.express(mallOrderVo.getOrderCode(), null, mallOrderVo.getMailNo());
//                if (express.getCode().equals("0")) {
//                    successNum++;
//                    successMsg.append("<br/>" + successNum + "、订单编号 " + mallOrderVo.getOrderCode() + " 导入发货成功");
//                } else {
//                    failureNum++;
//                    String msg = "<br/>" + failureNum + "、订单编号 " + mallOrderVo.getOrderCode() + " 失败原因：";
//                    failureMsg.append(msg + express.getMessage());
//                }
//            }
//            if (failureNum > 0) {
//                failureMsg.insert(0, "很抱歉，导入失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
//                throw new BusinessException(failureMsg.toString());
//            } else {
//                successMsg.insert(0, "恭喜您，数据已全部导入成功！共 " + successNum + " 条，数据如下：");
//            }
//            return successMsg.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
        return ResponseDto.success("订单导入成功");
    }
}
