package com.liquidnet.common.cache.redisson.handle;

import org.redisson.api.RLock;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;
/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: redisson封装接口
 * @class: RedisDistributedLocker
 * @Package com.liquidnet.service.redisson
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/9/11 16:11
 */
public interface DistributedLocker {
    RLock lock(String lockKey);

    RLock lock(String lockKey, int timeout);

    RLock lock(String lockKey, TimeUnit unit, int timeout);

    boolean tryLock(String lockKey, TimeUnit unit, int waitTime, int leaseTime);

    void unlock(String lockKey);

    void unlock(RLock lock);
}
