package com.liquidnet.common.web.config;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description:
 * @class: CorsConfig
 * @Package com.liquidnet.common.web.filter
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/12/21 6:57 下午
 */
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
public class CorsConfig {
    private CorsConfiguration buildConfig() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();

        // 可以自行筛选
        corsConfiguration.addAllowedOrigin("**");
        corsConfiguration.addAllowedOrigin("http://partner.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("https://partner.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("http://testpartner.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("https://testpartner.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("http://devpartner.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("https://devpartner.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("http://m.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("https://m.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("http://testm.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("https://testm.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("http://ttestm.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("https://ttestm.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("http://devm.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("https://devm.zhengzai.tv");

        corsConfiguration.addAllowedOrigin("http://devapplets.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("https://devapplets.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("http://testapplets.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("https://testapplets.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("http://applets.zhengzai.tv");
        corsConfiguration.addAllowedOrigin("https://applets.zhengzai.tv");

        corsConfiguration.setAllowCredentials(true);
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.addAllowedOrigin("*");


        return corsConfiguration;
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();

        source.registerCorsConfiguration("/**", buildConfig());

        return new CorsFilter(source);
    }
}
