package com.liquidnet.service.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.entity.*;
import com.liquidnet.service.goblin.service.GoblinFrontService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.mongodb.BasicDBObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.*;

@Service
public class GoblinFrontServiceImpl implements GoblinFrontService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    MongoTemplate mongoTemplate;

    @Override
    public ArrayList<GoblinFrontBannerVo> getListBanner() {
        List<GoblinFrontBanner> list= (List<GoblinFrontBanner>) redisUtil.get(GoblinRedisConst.FRONT_TOP_BANNER);
        LocalDateTime nowTime= LocalDateTime.now();
        ArrayList<GoblinFrontBanner> goblinFrontBannerArrayList= ObjectUtil.getGoblinFrontBannerArrayList();
        //查看是否有失效的时间
        for(GoblinFrontBanner goblinFrontBanner:list){
            if(null!=goblinFrontBanner.getEndTime()){
                if( nowTime.isAfter(goblinFrontBanner.getEndTime())){
                }else{
                    goblinFrontBannerArrayList.add(goblinFrontBanner);
                }
            }
        }
        ArrayList<GoblinFrontBannerVo> list1= ObjectUtil.goblinFrontBannerVoArrayList();
        for(GoblinFrontBanner goblinFrontBanner:goblinFrontBannerArrayList){
            GoblinFrontBannerVo goblinFrontBannerVo=GoblinFrontBannerVo.getNew();
            BeanUtils.copyProperties(goblinFrontBanner,goblinFrontBannerVo);
            list1.add(goblinFrontBannerVo);
        }
        return list1;
    }
    public ArrayList<GoblinFrontBannerVo> getMiddleBanner() {
        List<GoblinFrontBanner> list= (List<GoblinFrontBanner>) redisUtil.get(GoblinRedisConst.FRONT_MIDDLE_BANNER);
        LocalDateTime nowTime= LocalDateTime.now();
        ArrayList<GoblinFrontBanner> goblinFrontBannerArrayList= ObjectUtil.getGoblinFrontBannerArrayList();
        //查看是否有失效的时间
        for(GoblinFrontBanner goblinFrontBanner:list){
            if(null!=goblinFrontBanner.getEndTime()){
                if( nowTime.isAfter(goblinFrontBanner.getEndTime())){
                }else{
                    goblinFrontBannerArrayList.add(goblinFrontBanner);
                }
            }
        }
        ArrayList<GoblinFrontBannerVo> list1= ObjectUtil.goblinFrontBannerVoArrayList();
        for(GoblinFrontBanner goblinFrontBanner:goblinFrontBannerArrayList){
            GoblinFrontBannerVo goblinFrontBannerVo=GoblinFrontBannerVo.getNew();
            BeanUtils.copyProperties(goblinFrontBanner,goblinFrontBannerVo);
            list1.add(goblinFrontBannerVo);
        }
        return list1;
    }

    @Override
    public List<GoblinFrontHotWord> getHotWord() {
       // int index= (int) redisUtil.get(GoblinRedisConst.FRONT_HOTWORD_INDEX);
        //获得value
        List<GoblinFrontHotWord> list= (List<GoblinFrontHotWord>) redisUtil.get(GoblinRedisConst.FRONT_HOTWORD);
       /* index++;
        String hotWord="";
        redisUtil.set(GoblinRedisConst.FRONT_HOTWORD_INDEX,index);
        if(index<list.size()){
            hotWord= list.get(index).getWord();
        }else{
            hotWord= list.get(0).getWord();
        }*/
        return list;
    }

    @Override
    public List<GoblinFrontNavigation> getNavigation() {
        List<GoblinFrontNavigation> list = (List<GoblinFrontNavigation>) redisUtil.get(GoblinRedisConst.FRONT_NAVIGATION);
        return list;
    }

    @Override
    public GoblinFrontSeckillVo getSeckilll() throws ParseException {
        //获得秒杀列表绑定
        List<GoblinFrontSeckill> list= (List<GoblinFrontSeckill>) redisUtil.get(GoblinRedisConst.FRONT_SECKILL);
        GoblinFrontSeckillVo goblinFrontSeckillVo=GoblinFrontSeckillVo.getNew();
        ArrayList<GoblinGoodsInfoVo> goblinGoodsInfoVoArrayList=ObjectUtil.goblinGoodsInfoVoArrayList();
        //判断是否有
        if(null!=list&&list.size()>0){
            //遍历秒杀， 找到对应的  官方、商铺
            GoblinFrontSeckill goblinFrontSeckill=list.get(0);
            boolean openBoolean=goblinFrontSeckill.getActivityType()==2;
            String ids=goblinFrontSeckill.getSelfActivityids();
            if(StringUtil.isNotBlank(ids)){
                String[] idss=ids.split(",");
                for(String id:idss){
                    String type=id.split("_")[0];
                    String idM=id.split("_")[1];
                    if(type.equals("g")){
                        //找到对应官方的活动 判断时间是否过期，
                        GoblinSelfMarketingVo goblinSelfMarketingVo=goblinRedisUtils.getSelfMarket(idM);
                        if(!StringUtil.isNotBlank(goblinFrontSeckillVo.getStartTime())){
                            goblinFrontSeckillVo.setStartTime(goblinSelfMarketingVo.getStartTime());
                            goblinFrontSeckillVo.setEndTime(goblinSelfMarketingVo.getEndTime());
                        }
                        if(goblinSelfMarketingVo==null){
                            break;
                        }
                        if(!openBoolean){
                            //效验该活动是否在当前时间
                            if(!belongCalendar(goblinSelfMarketingVo.getStartTime(),goblinSelfMarketingVo.getEndTime())){
                                //如果不是在当前时间
                                break;
                            }
                        }
                        //查看 活动绑定的 spu   sku
                        List<GoblinMarketRelationVo>  list1=goblinRedisUtils.getMarketRelation(GoblinStatusConst.MarketPreStatus.MARKET_PRE_PURCHASE.getValue(),goblinSelfMarketingVo.getSelfMarketId());
                        //遍历 活动表
                        for(GoblinMarketRelationVo goblinMarketRelationVo:list1){
                            //找到对应的spu商品
                            GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.getGoodsInfoVo(goblinMarketRelationVo.getSpuId());
                            //遍历sku 找到
                            List<String> skuList=goblinMarketRelationVo.getSkuList();
                            int sellPrice=0;
                            int i=0;
                            for(String skuId:skuList){
                                GoblinGoodsSkuInfoVo goblinGoodsSkuInfoVo= goblinRedisUtils.getGoodsSkuInfoVo(skuId);
                                if(null!=goblinGoodsSkuInfoVo){
                                    if(i==0){
                                        sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                    }
                                    if(sellPrice>goblinGoodsSkuInfoVo.getSellPrice().intValue()){
                                        sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                    }
                                }
                            }
                            goblinGoodsInfoVo.setSellPrice(new BigDecimal(sellPrice));
                            goblinGoodsInfoVoArrayList.add(goblinGoodsInfoVo);
                        }
                    }else if(type.equals("s")){
                        //商铺活动的vo
                        GoblinStoreMarketVo goblinStoreMarketVo=goblinRedisUtils.getGoblinStoreMarketVo(idM);
                        if(!StringUtil.isNotBlank(goblinFrontSeckillVo.getStartTime())){
                            goblinFrontSeckillVo.setStartTime(goblinStoreMarketVo.getStartTime());
                            goblinFrontSeckillVo.setEndTime(goblinStoreMarketVo.getEndTime());
                        }
                        if(goblinStoreMarketVo==null){
                            break;
                        }
                        boolean isGet=false;
                        if(openBoolean){
                            //不做效验时间直接放true
                            isGet=true;
                        }else if(goblinStoreMarketVo.getIsPre()==1&&afterCalendar(goblinStoreMarketVo.getPreTime())&&beforeCalendar(goblinStoreMarketVo.getEndTime())){
                            isGet=true;
                        }else if(goblinStoreMarketVo.getIsPre()==0&&belongCalendar(goblinStoreMarketVo.getStartTime(),goblinStoreMarketVo.getEndTime())){
                            isGet=true;
                        }
                        if(isGet){
                            //获取商铺 对应关系
                            List<GoblinMarketRelationVo>  list1=goblinRedisUtils.getMarketRelation(GoblinStatusConst.MarketPreStatus.MARKET_PRE_PURCHASE.getValue(),goblinStoreMarketVo.getStoreMarketId());
                            //获得商品
                            //遍历 活动表
                            for(GoblinMarketRelationVo goblinMarketRelationVo:list1){
                                //找到对应的spu商品
                                GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.getGoodsInfoVo(goblinMarketRelationVo.getSpuId());
                                //遍历sku 找到
                                List<String> skuList=goblinMarketRelationVo.getSkuList();
                                int sellPrice=0;
                                int i=0;
                                for(String skuId:skuList){
                                    GoblinGoodsSkuInfoVo goblinGoodsSkuInfoVo= goblinRedisUtils.getGoodsSkuInfoVo(skuId);
                                    if(null!=goblinGoodsSkuInfoVo){
                                        if(i==0){
                                            sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                        }
                                        if(sellPrice>goblinGoodsSkuInfoVo.getSellPrice().intValue()){
                                            sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                        }
                                    }
                                }
                                goblinGoodsInfoVo.setSellPrice(new BigDecimal(sellPrice));
                                goblinGoodsInfoVoArrayList.add(goblinGoodsInfoVo);
                            }
                        }

                    }
                }
                goblinFrontSeckillVo.setGoblinGoodsInfoVoList(goblinGoodsInfoVoArrayList);
            }
        }
        return goblinFrontSeckillVo;
    }
    /**
     * 获得商品详情
     */
    public  GoblinFrontGoodDetailVo getGoodsDetail(String spuId){
        GoblinFrontGoodDetailVo goblinFrontGoodDetailVo=GoblinFrontGoodDetailVo.getNew();
        GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.getGoodsInfoVo(spuId);
        goblinFrontGoodDetailVo.setGoblinGoodsInfoVo(goblinGoodsInfoVo);

        return  goblinFrontGoodDetailVo;
    }
    /**
     * 获得商品详情
     */
    public  List getMoudleIndex(){
        //GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.get(spuId);
        List<GoblinFrontMoudleIndex> list= (List<GoblinFrontMoudleIndex>) redisUtil.get(GoblinRedisConst.MOUDLE_INDEX);
        return  list;
    }
    /***
     * @author zhangfuxin
     * @Description:获取魔方
     * @date 2022/1/10 下午4:49
     */
    public GoblinFrontCubeVo getCube(){
        GoblinFrontCubeVo goblinFrontCubeVo=GoblinFrontCubeVo.getNew();
        List<GoblinFrontCube> list= (List<GoblinFrontCube>) redisUtil.get(GoblinRedisConst.FRONT_GOBLINFRONTCUBE);
        if(list.size()>0){
            BeanUtils.copyProperties(list.get(0),goblinFrontCubeVo);
        }
        return goblinFrontCubeVo;
    }


    /**
     * @author zhangfuxin
     * @Description:精选商品列表
     * @date 2022/1/5 下午3:00
     */
    @Override
    public GoblinFrontSelectGoodVo getSelectGoods(int page, int pageSize) {
        //redis 取出精选商品列表
        List<GoblinFrontSelectGoods> list= (List<GoblinFrontSelectGoods>) redisUtil.get(GoblinRedisConst.SELECT_GOODS);
        if(null!=list&&list.size()==1){
            //获取商品列表
            String spuId=list.get(0).getSpuId();
            int start=page*pageSize;
            int end =start+pageSize;
            String[] ids=spuId.split(",");
            if(end>ids.length){
                end=ids.length;
            }
            //创建
            GoblinFrontSelectGoodVo goblinFrontSelectGoodVo=GoblinFrontSelectGoodVo.getNew();
            goblinFrontSelectGoodVo.setCount(ids.length);
            //
            ArrayList<GoblinGoodsInfoVo> goblinGoodsInfoVoArrayList= ObjectUtil.getGoblinGoodsInfoVos();
            for(int i=0;i<=end;i++){
               if (i>=start){
                   GoblinGoodsInfoVo goblinGoodsInfoVo= goblinRedisUtils.getGoodsInfoVo(ids[i]);
                   goblinGoodsInfoVoArrayList.add(goblinGoodsInfoVo);
               }
            }
            goblinFrontSelectGoodVo.setGoblinGoodsInfoVoList(goblinGoodsInfoVoArrayList);
            return goblinFrontSelectGoodVo;
        }
        return null;
    }

    public  boolean belongCalendar( String startString, String  endString) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.DATE_FULL_STR);//注意月份是MM
        Date from = simpleDateFormat.parse(startString);
        Date end= simpleDateFormat.parse(endString);
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        Calendar after = Calendar.getInstance();
        after.setTime(from);
        Calendar before = Calendar.getInstance();
        before.setTime(end);
        if (date.after(after) && date.before(before)) {
            return true;
        } else {
            return false;
        }
    }
    //判断是否是该时间之后
    public boolean afterCalendar(String time) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.DATE_FULL_STR);//注意月份是MM
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        Date timefrom = simpleDateFormat.parse(time);
        if (date.after(timefrom)) {
            return true;
        } else {
            return false;
        }
    }
    //判断是否是该时间之后
    public boolean beforeCalendar(String time) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.DATE_FULL_STR);//注意月份是MM
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        Date timefrom = simpleDateFormat.parse(time);
        if (date.before(timefrom)) {
            return true;
        } else {
            return false;
        }
    }
    /**
     * @author zhangfuxin
     * @Description:添加购物车
     * @date 2022/1/11 下午4:16
     */
    public boolean addShoopCart(String spuId, String storeId,String skuId,Integer number,String userId){
        //判断该用户 redis里是否有购物车
        GoblinShoppingCartVoo goblinShoppingCartVoo= (GoblinShoppingCartVoo) redisUtil.get(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        if(null==goblinShoppingCartVoo){
            //创建 voo
            GoblinShoppingCartVoo goblinShoppingCartVoo1=GoblinShoppingCartVoo.getNew();
            // 根据shop分类
            ArrayList<GoblinShoppingCartVo> list=ObjectUtil.goblinShoppingCartVoArrayList();
            GoblinShoppingCartVo goblinShoppingCartVo=GoblinShoppingCartVo.getNew();
            goblinShoppingCartVo.setStoreId(storeId);
            //该商铺下的所有商品
            ArrayList<GoblinShoppingCartVoDetail> list1=ObjectUtil.goblinShoppingCartVoDetailArrayList();
            //创建 购物车vo
            GoblinShoppingCartVoDetail goblinShoppingCartVoDetail=this.setValue(userId,storeId,spuId,skuId,1);
            list1.add(goblinShoppingCartVoDetail);
            goblinShoppingCartVo.setSkuList(list1);
            list.add(goblinShoppingCartVo);
            goblinShoppingCartVoo1.setShopList(list);
            goblinShoppingCartVoo1.setGoblinShoppingCartId(IDGenerator.nextSnowId());
            saveRedisMongodbMysqlShop(goblinShoppingCartVoo1,userId);
        }else{
            //查看是否有该商铺
            List<GoblinShoppingCartVo> list=goblinShoppingCartVoo.getShopList();
            boolean isShop=false;
            for(GoblinShoppingCartVo goblinShoppingCartVo:list){
                if(storeId.equals(goblinShoppingCartVo.getStoreId())){
                    //有这个商铺的 东西
                    List<GoblinShoppingCartVoDetail> list1=goblinShoppingCartVo.getSkuList();
                    //查看是否有这个商品
                    boolean isGoods=false;
                    for(GoblinShoppingCartVoDetail goblinShoppingCartVoDetail:list1){
                        if(skuId.equals(goblinShoppingCartVoDetail.getSkuId())){
                            isGoods=true;
                            goblinShoppingCartVoDetail.setNumber((goblinShoppingCartVoDetail.getNumber()+1));
                        }
                    }
                    if(isGoods){
                        //添加商品 数量
                        //不需要做
                    }else{
                        //创建商品放入到list
                        GoblinShoppingCartVoDetail goblinShoppingCartVoDetail=this.setValue(userId,storeId,spuId,skuId,1);
                        list1.add(goblinShoppingCartVoDetail);
                    }
                    isShop=true;
                }
            }
            if(!isShop){
                GoblinShoppingCartVo goblinShoppingCartVo=GoblinShoppingCartVo.getNew();
                goblinShoppingCartVo.setStoreId(storeId);
                //该商铺下的所有商品
                ArrayList<GoblinShoppingCartVoDetail> list1=ObjectUtil.goblinShoppingCartVoDetailArrayList();
                //创建 购物车vo
                GoblinShoppingCartVoDetail goblinShoppingCartVoDetail=this.setValue(userId,storeId,spuId,skuId,1);
                list1.add(goblinShoppingCartVoDetail);
                goblinShoppingCartVo.setSkuList(list1);
                list.add(goblinShoppingCartVo);
            }
            saveRedisMongodbMysqlShop(goblinShoppingCartVoo,userId);
        }
        return true;
    }
    /***
     * @author zhangfuxin
     * @Description: 修改 购物车里 数量
     * @date 2022/1/11 下午6:24
     */
    public  boolean updateShopCart(String spuId, String storeId,String skuId,Integer number,String userId){
        GoblinShoppingCartVoo goblinShoppingCartVoo= (GoblinShoppingCartVoo) redisUtil.get(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        if(null!=goblinShoppingCartVoo){
            List<GoblinShoppingCartVo>  list=goblinShoppingCartVoo.getShopList();
            //遍历商铺
            for(GoblinShoppingCartVo goblinShoppingCartVo:list){
                if(storeId.equals(goblinShoppingCartVo.getStoreId())){
                    //找到 商品id
                    List<GoblinShoppingCartVoDetail> list1=goblinShoppingCartVo.getSkuList();
                    for(GoblinShoppingCartVoDetail goblinShoppingCartVoDetail:list1){
                        if(skuId.equals(goblinShoppingCartVoDetail.getSkuId())){
                            goblinShoppingCartVoDetail.setNumber(number);
                        }
                    }
                }
            }
            //调用储存方法
            saveRedisMongodbMysqlShop(goblinShoppingCartVoo,userId);
        }
        return true;
    }

    public int getShopCartCount(String userId){
        int  count=0;
        GoblinShoppingCartVoo goblinShoppingCartVoo= (GoblinShoppingCartVoo) redisUtil.get(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        if(null!=goblinShoppingCartVoo){
            List<GoblinShoppingCartVo> shopList=goblinShoppingCartVoo.getShopList();
            for(GoblinShoppingCartVo goblinShoppingCartVo:shopList){
                List<GoblinShoppingCartVoDetail> skuList=goblinShoppingCartVo.getSkuList();
                for(GoblinShoppingCartVoDetail goblinShoppingCartVoDetail:skuList){
                    count=goblinShoppingCartVoDetail.getNumber()+count;
                }
            }
        }
        return count;
    }
    /**
     * 删除购物车里面的商品
     */
    public boolean delteShoppingCart(String[] skuIds,String userId) {
        boolean isDeleteAll = false;
        GoblinShoppingCartVoo goblinShoppingCartVoo = (GoblinShoppingCartVoo) redisUtil.get(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        if (null != goblinShoppingCartVoo) {
            List<GoblinShoppingCartVo> shopList = goblinShoppingCartVoo.getShopList();

            Iterator<GoblinShoppingCartVo> shopIter = shopList.iterator();
            while (shopIter.hasNext()){
                GoblinShoppingCartVo goblinShoppingCartVo=shopIter.next();
                List<GoblinShoppingCartVoDetail> skuList = goblinShoppingCartVo.getSkuList();
                Iterator<GoblinShoppingCartVoDetail> iterator = skuList.iterator();
                while(iterator.hasNext()){
                    GoblinShoppingCartVoDetail goblinShoppingCartVoDetail=iterator.next();
                    for (String skuId : skuIds) {
                        if (goblinShoppingCartVoDetail.getSkuId().equals(skuId)) {
                            //skuList.remove(goblinShoppingCartVoDetail);
                            iterator.remove();
                        }
                    }
                }
                if(skuList.size()==0){
                    shopIter.remove();
                }
            }
            if(shopList.size()==0){
                deleteRedisMongodbMysqlShop(goblinShoppingCartVoo,userId);
            }
        }

       /* if(this.getShopCartCount(userId)==0){
            //删除redis、删除mongodb
            deleteRedisMongodbMysqlShop(goblinShoppingCartVoo,userId);
        }else{
            saveRedisMongodbMysqlShop(goblinShoppingCartVoo,userId);
        }
*/
    return true;
    }
    /**
     * @author zhangfuxin
     * @Description: 获得购物车列表
     * @date 2022/1/12 下午2:36
     */
    public GoblinShoppingCartVoo getShoppCart(String userId){
        //判断该用户 redis里是否有购物车
        GoblinShoppingCartVoo goblinShoppingCartVoo= (GoblinShoppingCartVoo) redisUtil.get(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        if(null==goblinShoppingCartVoo){
            return null;
        }
        //遍历里面信息
        for(GoblinShoppingCartVo goblinShoppingCartVo:goblinShoppingCartVoo.getShopList()){
            for(GoblinShoppingCartVoDetail goblinShoppingCartVoDetail:goblinShoppingCartVo.getSkuList()){
                //找到对应的  spu  和 sku
                GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.getGoodsInfoVo(goblinShoppingCartVoDetail.getSpuId());
                GoblinGoodsSkuInfoVo goblinGoodsSkuInfoVo=goblinRedisUtils.getGoodsSkuInfoVo(goblinShoppingCartVoDetail.getSkuId());
                goblinShoppingCartVoDetail.setGoblinGoodsInfoVo(goblinGoodsInfoVo);
                goblinShoppingCartVoDetail.setGoblinGoodsSkuInfoVo(goblinGoodsSkuInfoVo);
            }
        }
        goblinShoppingCartVoo.setShoopingCount(this.getShopCartCount(userId));
        return goblinShoppingCartVoo;
    }
    public GoblinShoppingCartVoDetail setValue(String userId,String storeId,String spuId,String skuId,Integer number){
        GoblinShoppingCartVoDetail goblinShoppingCartVoDetail=GoblinShoppingCartVoDetail.getNew();
        goblinShoppingCartVoDetail.setCarId(IDGenerator.nextSnowId());
        goblinShoppingCartVoDetail.setUserId(userId);
        goblinShoppingCartVoDetail.setStoreId(storeId);
        goblinShoppingCartVoDetail.setSpuId(spuId);
        goblinShoppingCartVoDetail.setSkuId(skuId);
        goblinShoppingCartVoDetail.setNumber(number);
        goblinShoppingCartVoDetail.setDelTag(0);
        goblinShoppingCartVoDetail.setCreatedAt(LocalDateTime.now());
        goblinShoppingCartVoDetail.setUpdatedAt(LocalDateTime.now());
        return goblinShoppingCartVoDetail;
    }
    public void saveRedisMongodbMysqlShop(GoblinShoppingCartVoo goblinShoppingCartVoo,String userId){
        goblinShoppingCartVoo.setUserId(userId);
        //redis存储
        redisUtil.set(GoblinRedisConst.FRONT_SHOPCART.concat(userId),goblinShoppingCartVoo);
        //mongodb存储
        boolean exists2  =mongoTemplate.exists(Query.query(Criteria.where("goblinShoppingCartId").is(goblinShoppingCartVoo.getGoblinShoppingCartId())),GoblinShoppingCartVoo.class, GoblinShoppingCartVoo.class.getSimpleName());
        if(exists2){
            BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinShoppingCartVoo)));
            mongoTemplate.getCollection(GoblinShoppingCartVoo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("goblinShoppingCartId").is(goblinShoppingCartVoo.getGoblinShoppingCartId())).getQueryObject(),
                    orderObject
            );
        }else{
            mongoTemplate.save(goblinShoppingCartVoo,GoblinShoppingCartVoo.class.getSimpleName());
        }
        //mysql 消息队列
    }
    //删除redis 删除mongodb
    public void deleteRedisMongodbMysqlShop(GoblinShoppingCartVoo goblinShoppingCartVoo,String userId){
        //redis存储
        redisUtil.del(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        //mongodb 删除
        mongoTemplate.remove(Query.query(Criteria.where("goblinShoppingCartId").is(goblinShoppingCartVoo.getGoblinShoppingCartId())), GoblinShoppingCartVoo.class, GoblinShoppingCartVoo.class.getSimpleName());
    }


}
