package com.liquidnet.service.kylin.dto.vo;

import com.liquidnet.service.kylin.entity.KylinPerformanceRelations;
import com.liquidnet.service.kylin.entity.KylinPerformanceStatus;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.format.DateTimeFormatter;

@Data
public class PerformanceVo {

    @ApiModelProperty(value = "主键")
    private String performancesId;
    @ApiModelProperty(value = "演出名称")
    private String title;
    @ApiModelProperty(value = "演出开始时间")
    private String timeStart;
    @ApiModelProperty(value = "演出结束时间")
    private String timeEnd;
    @ApiModelProperty(value = "停售时间")
    private String stopSellTime;
    @ApiModelProperty(value = "价格")
    private String price;
    @ApiModelProperty(value = "开售时间")
    private String sellTime;

    //    @ApiModelProperty(value = "场地相关")
//    private String fields;
//@ApiModelProperty(value = "巡演相关")
//    private String roadShow;
    // OSS
//    @ApiModelProperty(value = "演出详情")
//    private String details;
    // OSS
//    @ApiModelProperty(value = "购票须知")
//    private String noticeImage;

    @ApiModelProperty(value = "状态")
    private int appStatus;
    @ApiModelProperty(value = "是否可买")
    private int statusSell;
    @ApiModelProperty(value = "是否关联会员")
    private int isMember;
    @ApiModelProperty(value = "是否开启缺票登记")
    private int isLackRegister;
    @ApiModelProperty(value = "是否专属")
    private int isExclusive;
    @ApiModelProperty(value = "文案")
    private String message;


    public void setPerformance(KylinPerformances performance) {
        this.performancesId = performance.getPerformancesId();
        this.title = performance.getTitle();
        this.timeStart = performance.getTimeStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.timeEnd = performance.getTimeEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public void setTimePriceVipAndLack() {
        this.isLackRegister = 0;
        this.timeEnd = "";
        this.stopSellTime = "";
        this.price = "";
        this.sellTime = "";
        this.isMember = 0;
        this.isExclusive = 0;
        this.appStatus = 0;
    }

    public void setPerformanceStatus(KylinPerformanceStatus performanceStatus) {
        this.statusSell = performanceStatus.getStatusSell();
//        this.message = performance.getPerformancesId();
    }
}
