package com.liquidnet.service.kylin.controller.admin;


import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.partner.PerformanceCreatePartnerVo;
import com.liquidnet.service.kylin.service.impl.admin.KylinPerformancesAdminServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 演出 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Api(tags = "后端-演出")
@RestController
@RequestMapping("admin/performance")
public class KylinPerformancesAdminController {

    @Autowired
    private KylinPerformancesAdminServiceImpl performancesAdminService;

    @GetMapping(value = "details")
    @ApiOperation(value = "获取演出详情")
    @ApiResponse(response = PerformanceCreatePartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<PerformanceCreatePartnerVo> performanceDetails(@RequestParam("performancesId") String performancesId) {
        PerformanceCreatePartnerVo result = null;
        result = performancesAdminService.performanceDetails(performancesId);
        if (null != result) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出详情失败");
        }
    }

    @GetMapping(value = "audit")
    @ApiOperation(value = "演出审核")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> performanceDetails(@RequestParam("performancesId") String performancesId, @RequestParam("status") int status, @RequestParam("rejectTxt") String rejectTxt) {
        boolean result = performancesAdminService.performanceAudit(performancesId, status, rejectTxt);
        if (result) {
            return ResponseDto.success("审核完成");
        } else {
            return ResponseDto.failure("审核失败");
        }
    }

}
