package com.liquidnet.service.adam.dto.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel(value = "AdamMemberBuildParam", description = "编辑会员入参")
@Data
public class AdamMemberBuildParam implements Serializable {
    private static final long serialVersionUID = -7411934614249221021L;
    @ApiModelProperty(required = false, value = "会员ID[64]")
    private String memberId;
    @ApiModelProperty(required = true, value = "会员名称[80]", example = "摩登天空会员卡")
    @NotBlank(message = "会员名称不能为空")
    private String name;
    @ApiModelProperty(required = true, value = "会员标题[100]", example = "摩登天空会员卡")
    @NotBlank(message = "会员标题不能为空")
    private String title;
    @ApiModelProperty(required = true, value = "会员副标题[255]", example = "摩登天空会员卡副标题")
    @NotBlank(message = "会员副标题不能为空")
    private String subTitle;
    @ApiModelProperty(required = true, value = "icon图标[255]", example = "https://img.zhengzai.tv/files/2020/08/28/5f490418d30b4.png")
    @NotBlank(message = "icon图标不能为空")
    private String icon;
    @ApiModelProperty(required = true, value = "会员头像[255]", example = "https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.png")
    @NotBlank(message = "会员头像不能为空")
    private String avatar;
    @ApiModelProperty(required = true, value = "弹窗文案[200]", example = "加入摩登天空会员您可享受到.....")
    @NotBlank(message = "弹窗文案不能为空")
    private String interestsDetail;
    @ApiModelProperty(required = true, value = "注意事项[200]", example = "摩登天空会员需注意以下事项.....")
    @NotBlank(message = "注意事项不能为空")
    private String notes;
    @ApiModelProperty(required = true, value = "是否开售:1-开售｜2-停售")
    @NotNull(message = "是否开售不能为空")
    private Integer onsale;
    @ApiModelProperty(required = false, value = "限购数量，0不限购[200]", example = "0")
    private Integer limitation;
    @ApiModelProperty(required = false, value = "限购开始时间[yyyy-MM-dd]")
    private String limitbAt;
    @ApiModelProperty(required = false, value = "限购结束时间[yyyy-MM-dd]")
    private String limiteAt;
}
