package com.liquidnet.service.kylin.dto.vo.returns;

import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "KylinStationPerformanceVo", description = "演出列表响应参数")
@Data
public class KylinStationPerformanceVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -4994363974994478286L;
    @ApiModelProperty(position = 10, value = "演出ID[64]")
    private String performancesId;
    @ApiModelProperty(position = 11, value = "类型[101-音乐节,102小型演出(livehouse演出),103巡演]")
    private Integer type;
    @ApiModelProperty(position = 12, value = "演出标题[255]")
    private String title;
    @ApiModelProperty(position = 13, value = "开始时间[yyyy/MM/dd]")
    private String timeStart;
    @ApiModelProperty(position = 14, value = "结束时间[yyyy/MM/dd]")
    private String timeEnd;
    @ApiModelProperty(position = 15, value = "城市名称")
    private String cityName;
    @ApiModelProperty(position = 16, value = "场地名称")
    private String fieldName;
    @ApiModelProperty(position = 17, value = "票种列表信息")
    private List<KylinStationTicketVo> ticketVoList;
    @ApiModelProperty(position = 18, value = "可下载时间")
    private String canDownTime;
    @ApiModelProperty(position = 20, value = "票房")
    private BigDecimal priceSum;
    @ApiModelProperty(position = 21, value = "票量[9]")
    private Integer number;
    @ApiModelProperty(position = 22, value = "已验票量[9]")
    private Integer checkedNum;
    @ApiModelProperty(position = 23, value = "余量[9]")
    private Integer remainderNum;

    private static final KylinStationPerformanceVo obj = new KylinStationPerformanceVo();

    public static KylinStationPerformanceVo getNew() {
        try {
            return (KylinStationPerformanceVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinStationPerformanceVo();
        }
    }

    public KylinStationPerformanceVo copy(KylinPerformanceVo source) {
        if (null == source) return this;
        this.performancesId = source.getPerformancesId();
        this.type = source.getType();
        this.title = source.getTitle();
        this.timeStart = source.getTimeStart();
        this.timeEnd = source.getTimeEnd();
        return this;
    }
}
