package com.liquidnet.service.dragon.channel.alipay.strategy.impl;

import com.liquidnet.service.dragon.channel.alipay.strategy.annotation.StrategyAlipayHandler;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AlipayStrategyWapImpl
 * @Package com.liquidnet.service.dragon.channel.alipay.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 14:34
 */
@Component
@StrategyAlipayHandler(DragonConstant.DeviceFromEnum.APP)
public class AlipayStrategyAppImpl extends AbstractAlipayStrategy {
    @Value("${liquidnet.dragon.alipay.gataway-url}")
    private String alipayGatewayUrl;

    @Value("${liquidnet.dragon.alipay.notify-url}")
    private String notifyUrl;

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    protected void setProductCode() {
        this.productCode = "QUICK_MSECURITY_PAY";
    }

    @Override
    protected String getNotifyUrl() {
        // notifyUrl = "/notify/app/alipay/1";
        return notifyUrl + "/app";
    }

    @Override
    DragonPayBaseRespDto buildResponseDto(DragonPayBaseRespDto payBaseRespDto, Map<String, Object> respResult) {
        payBaseRespDto.getPayData().setOrderStr(alipayGatewayUrl + "?" + respResult.get("order_string"));
        return payBaseRespDto;
    }
}