package com.liquidnet.service.dragon.controller;

import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.service.IDragonOrdersService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PayController
 * @Package com.liquidnet.service.dragon.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/9 12:29
 */
@RestController
@RequestMapping("pay")
public class PayController {
    @Autowired
    private IDragonOrdersService dragonOrdersService;

    /**
     * 电脑网页支付宝支付
     * @return
     */
    @PostMapping("/dragonPay")
    @ApiOperation("Dragon支付")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "payType", value = "支付类型:alipay,wepay,iappay", example = "alipay"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "deviceFrom", value = "设备来源:web,wap,app,js,apple", example = "wap"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "业务类型:TICKET,PRODUCT,COST,MBEANS,LIVE,VIDEO,VIP,CLUB,STRAWBERRY", example = "TICKET"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "price", value = "支付金额", example = "0.1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "name", value = "订单名称", example = "测试订单001"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "detail", value = "订单描述", example = "测试订单001"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderCode", value = "订单编号", example = "ORDER0001"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "clientIp", value = "客户端ip", example = "127.0.0.1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "notifyUrl", value = "通知url", example = "pay.zhengzai.tv"),
    })
    @ResponseBody
    public ResponseDto<DragonPayBaseRespDto> dragonPay(
            @RequestParam(value = "payType") @NotNull(message = "支付类型不能为空") String payType,
            @RequestParam(value = "deviceFrom") @NotNull(message = "设备来源不能为空") String deviceFrom,
            @RequestParam(value = "openId") String openId,
            @RequestParam(value = "type") @NotNull(message = "业务类型不能为空") String type,
               @RequestParam(value = "price") @NotNull(message = "支付金额不能为空") BigDecimal price,
               @RequestParam(value = "name") @NotNull(message = "订单名称不能为空") String name,
               @RequestParam(value = "detail") @NotNull(message = "订单描述不能为空") String detail,
               @RequestParam(value = "orderCode") @NotNull(message = "订单编号不能为空") String orderCode,
               @RequestParam(value = "clientIp") @NotNull(message = "客户端ip不能为空") String clientIp,
               @RequestParam(value = "notifyUrl") @NotNull(message = "通知Url不能为空") String notifyUrl,
               @RequestParam(value = "returnUrl",required = false)  String returnUrl,
               @RequestParam(value = "quitUrl",required = false)  String quitUrl,
               @RequestParam(value = "showUrl",required = false)  String showUrl,
               @RequestParam(value = "code",required = false)  String code,
               @RequestParam(value = "createDate",required = false)  String createDate,
               @RequestParam(value = "expireTime",required = false)  String expireTime){
        if(payType.equalsIgnoreCase(DragonConstant.PayChannelEnum.WEPAY.getCode())){
            if(StringUtil.isEmpty(openId)){
                return ResponseDto.failure("微信支付openId不能为空!");
            }
        }
        DragonPayBaseReqDto dragonPayBaseReqDto = new DragonPayBaseReqDto();
        dragonPayBaseReqDto.setPayType(payType);
        dragonPayBaseReqDto.setDeviceFrom(deviceFrom);
        dragonPayBaseReqDto.setOpenId(openId);
        dragonPayBaseReqDto.setType(type);
        dragonPayBaseReqDto.setPrice(price);
        dragonPayBaseReqDto.setName(name);
        dragonPayBaseReqDto.setDetail(detail);
        dragonPayBaseReqDto.setOrderCode(orderCode);
        dragonPayBaseReqDto.setClientIp(clientIp);
        dragonPayBaseReqDto.setNotifyUrl(notifyUrl);
        return dragonOrdersService.dragonPay(dragonPayBaseReqDto);
    }
}
