package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author TT
 */

@ApiModel(value = "NoticeGoblinMixDetailsItemVo", description = "票务")
@Data
public class NoticeGoblinMixDetailsItemVo implements Serializable, Cloneable {
    @ApiModelProperty(value = "spuId")
    private String spuId;
    @ApiModelProperty(value = "skuId")
    private String skuId;
    @ApiModelProperty(value = "skuId")
    private String skuPic;
    @ApiModelProperty(value = "sku名称")
    private String skuName;
    @ApiModelProperty(value = "spu名称")
    private String spuName;
    @ApiModelProperty(value = "商品类型[1-商城|2-数字藏品]")
    private String position;
    @ApiModelProperty(value = "sku原价")
    private BigDecimal skuPrice;
    @ApiModelProperty(value = "组合价格")
    private BigDecimal price;
    @ApiModelProperty(value = "苹果价格")
    private BigDecimal priceV;
    @ApiModelProperty(value = "苹果价格id")
    private String productId;
    @ApiModelProperty(value = "组合件数[数字藏品不能大于1]")
    private Integer count;

    private static final NoticeGoblinMixDetailsItemVo obj = new NoticeGoblinMixDetailsItemVo();

    public static NoticeGoblinMixDetailsItemVo getNew() {
        try {
            return (NoticeGoblinMixDetailsItemVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new NoticeGoblinMixDetailsItemVo();
        }
    }

    public NoticeGoblinMixDetailsItemVo copy(GoblinMixDetailsItemVo goblinMixDetailsItemVo){
        if (null==goblinMixDetailsItemVo) return getNew();
        this.count = goblinMixDetailsItemVo.getCount();
        this.position = goblinMixDetailsItemVo.getPosition();
        this.priceV = goblinMixDetailsItemVo.getPriceV();
        this.price = goblinMixDetailsItemVo.getPrice();
        this.productId = goblinMixDetailsItemVo.getProductId();
        this.skuId = goblinMixDetailsItemVo.getSkuId();
        this.skuName = goblinMixDetailsItemVo.getSkuName();
        this.skuPic = goblinMixDetailsItemVo.getSkuPic();
        this.skuPrice = goblinMixDetailsItemVo.getSkuPrice();
        this.spuId = goblinMixDetailsItemVo.getSpuId();
        this.spuName = goblinMixDetailsItemVo.getSpuName();
        return this;
    }



}
