package com.liquidnet.service.galaxy.dto.bo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftOrderBindBo
 * @Package com.liquidnet.service.galaxy.dto.bo
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/31 13:36
 */
@Data
public class GalaxyNftOrderBindBo implements Serializable,Cloneable{
    /**
     * 接入方买入唯一标识
     */
    private String nftOrderPayId;
    /**
     * 系列唯一编码
     */
    private String seriesCode;
    /**
     * 系列的唯一Id
     */
    private String seriesId;
    /**
     * nftId索引
     */
    private Integer nftIdIndex;
    /**
     * 路由类型
     */
    private String routerType;
    /**
     * 创建时间
     */
    private String createdAt;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftOrderBindBo obj = new GalaxyNftOrderBindBo();

    public static GalaxyNftOrderBindBo getNew() {
        try {
            return (GalaxyNftOrderBindBo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftOrderBindBo();
        }
    }
}
