package com.liquidnet.service.goblin.dto;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * mongo队列消息体
 *
 * @author jiangxiulong
 */
@Data
public class GoblinQueueBizMongoDto implements Serializable, Cloneable {

    private static final long serialVersionUID = -5850588358672254766L;
    /**
     * Mongo集合名
     */
    private String collect;
    /**
     * Mongo集合中的字段属性名称
     */
    private String column;
    /**
     * Mongo集合中的字段属性值
     */
    private String bizId;
    /**
     * Redis缓存中的Key前缀
     */
    private String prefix;
    /**
     * 操作类型[1-insert|2-update]
     */
    private int opType;

    private static final GoblinQueueBizMongoDto obj = new GoblinQueueBizMongoDto();

    public static GoblinQueueBizMongoDto getNew() {
        try {
            return (GoblinQueueBizMongoDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinQueueBizMongoDto();
        }
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }
}
