package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author jobob
 * @since 2022-03-11
 */
@ApiModel(value = "smileUser", description = "smile的user")
@Data
public class SmileUserVO implements Serializable {

    public interface saveOne{}
    public interface saveTwo{}
    public interface saveThree{}

    private static final long serialVersionUID = 1L;

    private Long id;
    @ApiModelProperty(value = "用户id")
    private String uid;

    @ApiModelProperty(value = "总代理id，如果总代理是其本身则是本uid，如果不是则是上级uid")
    private String agentId;

    /**
     * 照片
     */
    @ApiModelProperty(value = "照片")
    @NotBlank(groups = {saveOne.class},message = "照片必传")
    private String img;

    /**
     * 真实姓名
     */
    @ApiModelProperty(value = "姓名")
    @NotBlank(groups = {saveOne.class},message = "姓名必传")
    private String nameOneStep;
    /**
     * 真实姓名
     */
    @ApiModelProperty(value = "真实姓名")
    @NotBlank(groups = {saveTwo.class},message = "真实姓名必传")
    private String name;

    /**
     * 生日YYYY-MM-DD
     */
    @ApiModelProperty(value = "生日(yyyy-MM-dd)")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_SMALL_STR)
    //@Past(groups = {saveOne.class},message = "生日必传")
    @NotNull(groups = {saveOne.class},message = "生日必传")
    private LocalDate birthday;

    /**
     * 性别(1：男（默认），2：女)
     */
    @ApiModelProperty(value = "性别(1：男（默认），2：女)")
    @Positive(groups = {saveOne.class},message = "性别必传")
    private Integer sex;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号")
    @NotBlank(groups = {saveOne.class},message = "手机必传")
    private String phone;

    /**
     * 省key
     */
    @ApiModelProperty(value = "省key")
    @NotBlank(groups = {saveOne.class},message = "省必传")
    private String provinceId;

    /**
     * 省
     */
    @ApiModelProperty(value = "省")
    @NotBlank(groups = {saveOne.class},message = "省必传")
    private String province;

    /**
     * 市key
     */
    @ApiModelProperty(value = "市key")
    @NotBlank(groups = {saveOne.class},message = "市必传")
    private String cityId;

    /**
     * 市
     */
    @ApiModelProperty(value = "市")
    @NotBlank(groups = {saveOne.class},message = "市必传")
    private String city;

    /**
     * 区key
     */
    @ApiModelProperty(value = "区key")
    @NotBlank(groups = {saveOne.class},message = "区必传")
    private String areaId;

    /**
     * 区
     */
    @ApiModelProperty(value = "区")
    @NotBlank(groups = {saveOne.class},message = "区必传")
    private String area;

    /**
     * 详细地址
     */
    @ApiModelProperty(value = "详细地址")
   /* @NotBlank(groups = {saveOne.class},message = "详细地址必传")*/
    private String address;

    /**
     * 微信号
     */
    @ApiModelProperty(value = "微信号")
    //@NotBlank(groups = {saveOne.class},message = "微信号必传")
    private String wechat;

    /**
     *
     */
    @ApiModelProperty(value = "代理类型（0：未审核，1：总代，2：普代，3：未认证4：驳回审核）")
    private Integer type;

    /**
     * 组织关联
     */
    @ApiModelProperty(value = "组织关联")
    private Long orgId;

    /**
     * 身份证号
     */
    @ApiModelProperty(value = "身份证号")
    @NotBlank(groups = {saveTwo.class},message = "身份证号必传")
    private String idCard;

    /**
     * 学校名称
     */
    @ApiModelProperty(value = "学校名称")
    @NotBlank(groups = {saveOne.class},message = "学校名称必传")
    private String schoolName;

    /**
     * 专业
     */
    @ApiModelProperty(value = "专业")
    @NotBlank(groups = {saveOne.class},message = "专业必传")
    private String schoolMajor;

    /**
     * 身份（1:在校学生（默认），2已毕业）
     */
    @ApiModelProperty(value = "身份（1:在校学生（默认），2已毕业）")
    @Positive(groups = {saveOne.class},message = "身份必传")
    private Integer identity;

    /**
     * 标识步骤
     */
    @ApiModelProperty(value = "标识步骤")
    private String tag;

    /**
     * 1：代理开启，2：代理关闭
     */
    @ApiModelProperty(value = "1：代理开启，2：代理关闭")
    private Integer agent;

    /**
     * 自我介绍
     */
    @ApiModelProperty(value = "自我介绍")
    @NotBlank(groups = {saveThree.class},message = "自我介绍必传")
    private String introduce;

    /**
     * 擅长1
     */
    @ApiModelProperty(value = "擅长1")
    private String specialty1;

    /**
     * 擅长2
     */
    @ApiModelProperty(value = "擅长2")
    private String specialty2;

    /**
     * 擅长3
     */
    @ApiModelProperty(value = "擅长3")
    private String specialty3;

    /**
     * 正常/黑名单
     */
    @ApiModelProperty(value = "0正常、1黑名单")
    private Integer state;

    /**
     * 0：删除，1正常
     */
    @ApiModelProperty(value = "0-未删除|1-删除]")
    private Integer delTag;
    /**
     * 认证标识
     *//*
    @ApiModelProperty(value = "（0:未审核，1：通过，2：未通过）")
    private Integer authTag;*/

    /**
     * 认证失败原因
     */
    @ApiModelProperty(value = "认证失败原因")
    private String errorReason;

    @ApiModelProperty(value = "学校id")
    private String schoolId;

    @ApiModelProperty(value = "票提信息")
    SmileAgentVo smileAgentVo;

    private LocalDateTime createdDate;

    private LocalDateTime updatedDate;

    private  int authStatus;


}
