package com.liquidnet.client.admin.zhengzai.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberRightsAdminService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.admin.AdamMemberRightsBuildParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberRightsVo;
import com.liquidnet.service.adam.entity.AdamMemberRights;
import com.liquidnet.service.adam.mapper.AdamMemberRightsMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

@Service
public class AdamMemberRightsAdminServiceImpl extends ServiceImpl<AdamMemberRightsMapper, AdamMemberRights> implements IAdamMemberRightsAdminService {
    @Autowired
    private AdamMemberRightsMapper adamMemberRightsMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    @Override
    public boolean edit(AdamMemberRightsBuildParam param) {
        String loginName = ShiroUtils.getLoginName();
        LocalDateTime now = LocalDateTime.now();
        String mrightsId = param.getMrightsId();

        boolean saveOrUpadateRst, isAddFlag = StringUtils.isEmpty(mrightsId);
        AdamMemberRights saveOrUpdateInfo = new AdamMemberRights();
        if (isAddFlag) {
            saveOrUpdateInfo.setMrightsId(IDGenerator.nextMilliId2());
            saveOrUpdateInfo.setMemberId(param.getMemberId());
            saveOrUpdateInfo.setState(1);

            saveOrUpdateInfo.setSeqNo(param.getSeqNo());
            saveOrUpdateInfo.setTitle(param.getTitle());
            saveOrUpdateInfo.setSubTitle(param.getSubTitle());
            saveOrUpdateInfo.setLabel(param.getLabel());
            saveOrUpdateInfo.setCover(param.getCover());
            saveOrUpdateInfo.setDetail(param.getDetail());
            saveOrUpdateInfo.setOperator(loginName);
            saveOrUpdateInfo.setCreatedAt(now);

            saveOrUpadateRst = adamMemberRightsMapper.insert(saveOrUpdateInfo) > 0;
        } else {
            LambdaUpdateWrapper<AdamMemberRights> updateWrapper = Wrappers.lambdaUpdate(AdamMemberRights.class).eq(AdamMemberRights::getState, 1)
                    .eq(AdamMemberRights::getMemberId, param.getMemberId())
                    .eq(AdamMemberRights::getMrightsId, param.getMrightsId());

            saveOrUpdateInfo.setState(param.getState());
            saveOrUpdateInfo.setOperator(loginName);
            saveOrUpdateInfo.setUpdatedAt(now);
            if (param.getState() != 2) {
                saveOrUpdateInfo.setSeqNo(param.getSeqNo());
                saveOrUpdateInfo.setTitle(param.getTitle());
                saveOrUpdateInfo.setSubTitle(param.getSubTitle());
                saveOrUpdateInfo.setLabel(param.getLabel());
                saveOrUpdateInfo.setCover(param.getCover());
                saveOrUpdateInfo.setDetail(param.getDetail());
            }

            saveOrUpadateRst = adamMemberRightsMapper.update(saveOrUpdateInfo, updateWrapper) > 0;
        }


        if (saveOrUpadateRst) {
            // 同步REDIS:用户端:购买会员详情页:权益列表
            List<AdamMemberRightsVo> vos = (List<AdamMemberRightsVo>) redisDataSourceUtil.getRedisAdamUtil().get(AdamRedisConst.INFO_MEMBER_RIGHTS.concat(param.getMemberId()));
            if (CollectionUtils.isEmpty(vos)) {
                vos = new ArrayList<>();
            }
            if (isAddFlag) {
                vos.add(AdamMemberRightsVo.getNew().copy(saveOrUpdateInfo));
            } else {
                if (param.getState() == 2) {// 移除
                    vos.removeIf(r -> r.getMrightsId().equals(param.getMrightsId()));
                } else {
                    List<AdamMemberRightsVo> finalVos = vos;
                    int idx = IntStream.range(0, finalVos.size())
                            .filter(i -> finalVos.get(i).getMrightsId().equals(mrightsId))
                            .findFirst().orElse(-1);
                    if (-1 == idx) {
                        vos.add(AdamMemberRightsVo.getNew().copy(saveOrUpdateInfo));
                    } else {
                        AdamMemberRightsVo existVo = vos.get(idx);

                        existVo.setSeqNo(saveOrUpdateInfo.getSeqNo());
                        existVo.setTitle(saveOrUpdateInfo.getTitle());
                        existVo.setSubTitle(saveOrUpdateInfo.getSubTitle());
                        existVo.setLabel(saveOrUpdateInfo.getLabel());
                        existVo.setCover(saveOrUpdateInfo.getCover());
                        existVo.setDetail(saveOrUpdateInfo.getDetail());

                        vos.set(idx, existVo);
                    }
                }
            }
            redisDataSourceUtil.getRedisAdamUtil().set(AdamRedisConst.INFO_MEMBER_RIGHTS.concat(param.getMemberId()), vos);
        }

        return saveOrUpadateRst;
    }
}
