package com.liquidnet.service.kylin.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserProfileVo;
import com.liquidnet.service.base.ResponseDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

import java.time.LocalDateTime;

/**
 * @author TT
 */
@Component
@Slf4j
public class GoblinAnticipateUtils {

    @Value("${liquidnet.service.adam.url}")
    private String adamUrl;

    public AdamUserInfoVo getUserInfo() {
        try {
            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Authorization", "Bearer " + CurrentUtil.getToken());
            header.add("Accept", "application/json;charset=UTF-8");

            String returnData = HttpUtil.post(adamUrl + "/adam/user/info", null, header);
            ResponseDto<AdamUserProfileVo> innerReturnVo = JsonUtils.fromJson(returnData, new TypeReference<ResponseDto<AdamUserProfileVo>>() {
            });
            if (innerReturnVo.getData() != null) {
                return innerReturnVo.getData().getUserInfo();
            }
            log.info("post url:{}<----->Authorization:{}", adamUrl + " /adam/user/info", CurrentUtil.getToken());
            return null;
        } catch (Exception e) {
            log.info("post url:{}<----->Authorization:{}", adamUrl + " /adam/user/info", CurrentUtil.getToken());
            log.error("获取用户头像失败", e);
            return null;
        }
    }

    public static Integer setState(LocalDateTime startDate, LocalDateTime endDate) {

        LocalDateTime now = LocalDateTime.now();
        if (startDate.isAfter(now)) {
            //未开始  0
            return 0;
        }
        if (startDate.isBefore(now) && endDate.isAfter(now)) {
            //预约中 1
            return 1;
        }
        if (endDate.isBefore(now)) {
            //已结束 2
            return 2;
        }
        //其他
        return null;
    }
}
