package com.liquidnet.service.galaxy.router.zxin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishResultQueryReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishResultQueryRespDto;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyPublish;
import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterPublishHandler;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinPublishBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PayChannelStrategyAlipayImpl
 * @Package com.liquidnet.service.dragon.channel.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/18 13:06
 */
@Slf4j
@Component
@StrategyGalaxyRouterPublishHandler(GalaxyEnum.RouterTypeEnum.ZXINCHAIN)
public class GalaxyRouterStrategyZxlPublishImpl implements IGalaxyRouterStrategyPublish {
    @Autowired
    private ZxinPublishBiz zxinPublishBiz;

    @Override
    public ResponseDto<GalaxyNftPublishRespDto> nftPublish(GalaxyNftPublishReqDto reqDto) {
        return zxinPublishBiz.nftPublish(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftPublishResultQueryRespDto> nftPublishResultQuery(GalaxyNftPublishResultQueryReqDto reqDto) {
        return zxinPublishBiz.nftPublishResultQuery(reqDto);
    }
}
