package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.UserCheckParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.UserCheckVo;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileUserCheckService;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.service.smile.entity.SmileUser;
import com.liquidnet.service.smile.entity.SmileUserCheck;
import com.liquidnet.service.smile.mapper.SmileSchoolMapper;
import com.liquidnet.service.smile.mapper.SmileUserCheckMapper;
import com.liquidnet.service.smile.mapper.SmileUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-15
 */
@Service
public class SmileUserCheckServiceImpl extends ServiceImpl<SmileUserCheckMapper, SmileUserCheck> implements ISmileUserCheckService {

    @Autowired
    SmileUserCheckMapper smileUserCheckMapper;

    @Autowired
    SmileUserMapper smileUserMapper;

    @Autowired
    SmileSchoolMapper smileSchoolMapper;

    @Override
    public PageInfo<UserCheckVo> listUserCheck(UserCheckParam userCheckParam) {
        PageInfo<UserCheckVo> pageInfo;

        try {
            Map<String, Object> map = BeanUtil.convertBeanToMap(userCheckParam);
            smileUserMapper.selectUserCheck(map);
            pageInfo =new PageInfo<>();
        } catch (Exception e) {
            e.printStackTrace();
        }


        //查询审核列表
        List<UserCheckVo> userCheckVos = smileUserCheckMapper.selectList(null).stream().map(smileUserCheck -> {
            //查询用户详情
            LambdaQueryWrapper<SmileUser> queryWrapper = Wrappers.lambdaQuery(SmileUser.class);
            queryWrapper.eq(SmileUser::getUid, smileUserCheck.getUid());
            queryWrapper.eq(SmileUser::getDelTag, 0);
            SmileUser smileUser = smileUserMapper.selectOne(queryWrapper);
            return UserCheckVo.builder()
                    .id(smileUserCheck.getId())
                    .uid(smileUserCheck.getUid())
                    .state(smileUserCheck.getState())
                    .reason(smileUserCheck.getReason())
                    .img(smileUser.getImg())
                    .name(smileUser.getName())
                    .birthday(smileUser.getBirthday())
                    .sex(smileUser.getSex())
                    .phone(smileUser.getPhone())
                    .provinceKey(smileUser.getProvinceKey())
                    .province(smileUser.getProvince())
                    .city(smileUser.getCity())
                    .cityKey(smileUser.getCityKey())
                    .area(smileUser.getArea())
                    .areaKey(smileUser.getAreaKey())
                    .address(smileUser.getAddress())
                    .schoolName(smileUser.getSchoolName())
                    .identity(smileUser.getIdentity())
                    .build();
        }).collect(Collectors.toList());
        return null;
    }

    @Override
    public boolean create(SmileUserCheck smileUserCheck) {
        if (smileUserCheck.getUid() != null) {
            LambdaQueryWrapper<SmileUserCheck> queryWrapper = Wrappers.lambdaQuery(SmileUserCheck.class);
            queryWrapper.eq(SmileUserCheck::getUid, smileUserCheck.getUid());
            if (smileUserCheckMapper.selectOne(queryWrapper) == null) {
                smileUserCheck.setCreatedDate(LocalDateTime.now());
                smileUserCheck.setUpdatedDate(LocalDateTime.now());
                smileUserCheck.setDelTag(0);
                return smileUserCheckMapper.insert(smileUserCheck) > 0;
            }
        }
        return false;
    }


}
