package com.liquidnet.service.chime.test;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.chime.constant.ChimeConstant;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestRedis
 * @Package com.liquidnet.service.adam.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/29 13:36
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestRedis {
    @Autowired
    private RedisUtil redisUtil;

    @Test
    public void setCityName() {
        String allowCity = "山西|北京";
        String notAllowCity = "北京|天津";
        redisUtil.getRedisTemplateByDb(250).opsForValue().set(ChimeConstant.REDIS_CITY_NAME_ALLOW,allowCity);
        redisUtil.getRedisTemplateByDb(250).opsForValue().set(ChimeConstant.REDIS_CITY_NAME_NOT_ALLOW,notAllowCity);

        String allowPerIds = "3142303054611251275691230|3142303054611251275691231";
        String notAllowPerIds = "314230305461125127569123|14230305461125127569124";
        redisUtil.getRedisTemplateByDb(250).opsForValue().set(ChimeConstant.REDIS_PERFORMANCE_IDS_ALLOW,allowPerIds);
        redisUtil.getRedisTemplateByDb(250).opsForValue().set(ChimeConstant.REDIS_PERFORMANCE_IDS_NOT_ALLOW,notAllowPerIds);
    }
}
