package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 49.NFT转移状态查询 GET请求方式
 * @class: NftTransferResultReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:57
 */
@Data
public class Nft049TransferResultReqDto implements Serializable {
    /**
     * nft可操作者的公钥
     */
    private String operatorPubKey;
    /**
     * 任务Id
     */
    private String taskId;
    private static final Nft049TransferResultReqDto obj = new Nft049TransferResultReqDto();
    private static final long serialVersionUID = 6225116351589870609L;

    public static Nft049TransferResultReqDto getNew() {
        try {
            return (Nft049TransferResultReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft049TransferResultReqDto();
        }
    }
}
