package com.liquidnet.service.order.utils;

import com.liquidnet.service.goblin.dto.vo.*;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.UpdateResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

@Component
public class GoblinMongoUtils {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    GoblinRedisUtils redisUtils;

    public GoblinStoreInfoVo getStoreInfoVo(String storeId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("storeId").is(storeId).and("delFlg").is("0")),
                GoblinStoreInfoVo.class, GoblinStoreInfoVo.class.getSimpleName());
    }

    // SPU信息
    public GoblinGoodsInfoVo getGoodsInfoVo(String spuId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("spuId").is(spuId)),
                GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());
    }

    // SKU信息
    public GoblinGoodsSkuInfoVo getGoodsSkuInfoVo(String skuId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("skuId").is(skuId)),
                GoblinGoodsSkuInfoVo.class, GoblinGoodsSkuInfoVo.class.getSimpleName());
    }

    //添加 订单vo全量
    public GoblinStoreOrderVo insertGoblinStoreOrderVo(GoblinStoreOrderVo vo) {
        return mongoTemplate.insert(vo, GoblinStoreOrderVo.class.getSimpleName());
    }

    public void insertGoblinStoreOrderVos(List<GoblinStoreOrderVo> vos) {
        mongoTemplate.insert(vos, GoblinStoreOrderVo.class.getSimpleName());
    }

    public UpdateResult updateGoblinStoreOrderVo(String orderId, GoblinStoreOrderVo data) {
        BasicDBObject object = ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data));
        return mongoTemplate.getCollection(GoblinStoreOrderVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderId").is(orderId)).getQueryObject(),
                object);
    }

    //添加 订单SkuVo全量
    public GoblinOrderSkuVo insertGoblinOrderSkuVo(GoblinOrderSkuVo vo) {
        return mongoTemplate.insert(vo, GoblinOrderSkuVo.class.getSimpleName());
    }

    //添加 订单SkuVo全量
    public void insertGoblinOrderSkuVoList(List<GoblinOrderSkuVo> vos) {
        mongoTemplate.insert(vos, GoblinOrderSkuVo.class.getSimpleName());
    }

    public UpdateResult updateGoblinOrderSkuVo(String orderSkuId, GoblinOrderSkuVo data) {
        BasicDBObject object = ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data));
        return mongoTemplate.getCollection(GoblinOrderSkuVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderSkuId").is(orderSkuId)).getQueryObject(),
                object);
    }

    //添加 操作日志
    public GoblinOrderLogVo insertGoblinOrderLogVo(GoblinOrderLogVo vo) {
        return mongoTemplate.insert(vo, GoblinOrderLogVo.class.getSimpleName());
    }

    //修改 订单退款数据
    public UpdateResult updateGoblinBackOrderVo(String backOrderId, GoblinBackOrderVo data) {
        BasicDBObject object = ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data));
        return mongoTemplate.getCollection(GoblinBackOrderVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("backOrderId").is(backOrderId)).getQueryObject(),
                object);
    }

    //获取 订单退款数据根据orderCode
    public GoblinBackOrderVo getGoblinBackOrderVoByBackCode(String backCode) {
        return mongoTemplate.findOne(Query.query(Criteria.where("backCode").is(backCode)), GoblinBackOrderVo.class, GoblinBackOrderVo.class.getSimpleName());
    }

    public Boolean changeCouponVos(String ucouponId, GoblinUserCouponBasicVo vo) {
        return mongoTemplate.getCollection(GoblinUserCouponBasicVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("ucouponId").is(ucouponId)).getQueryObject(),
                Update.update("state", vo.getState())
                        .set("usedFor", vo.getUsedFor())
                        .getUpdateObject()
        ).getModifiedCount() > 0;
    }

    public GoblinStoreCouponBasicVo getMgtStoreCouponBasicVo(String storeCouponId) {
        return mongoTemplate.findOne(
                Query.query(Criteria.where("storeCouponId").is(storeCouponId).and("delFlg").is("0")),
                GoblinStoreCouponBasicVo.class, GoblinStoreCouponBasicVo.class.getSimpleName()
        );
    }

    //添加 订单退款数据
    public GoblinBackOrderVo insertGoblinBackOrderVo(GoblinBackOrderVo vo) {
        return mongoTemplate.insert(vo, GoblinBackOrderVo.class.getSimpleName());
    }

    /* --------------------------------NFT--------------------------------- */

    // 订单详情vo
    public void setGoblinNftOrderVo(GoblinNftOrderVo vo) {
        mongoTemplate.insert(vo, GoblinNftOrderVo.class.getSimpleName());
    }

    public UpdateResult updateGoblinNftOrderVo(String orderId, HashMap<String, Object> data) {
        return mongoTemplate.getCollection(GoblinNftOrderVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderId").is(orderId)).getQueryObject(),
                ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data))
        );
    }

    //添加 订单退款数据
    public GoblinNftOrderRefundVo insertGoblinNftOrderRefundVo(GoblinNftOrderRefundVo vo) {
        return mongoTemplate.insert(vo, GoblinNftOrderRefundVo.class.getSimpleName());
    }

    //获取 订单退款数据
    public GoblinNftOrderRefundVo getGoblinNftOrderRefundVo(String refundCode) {
        return mongoTemplate.findOne(Query.query(Criteria.where("refundCode").is(refundCode)), GoblinNftOrderRefundVo.class, GoblinNftOrderRefundVo.class.getSimpleName());
    }

    //修改 订单退款数据
    public UpdateResult updateGoblinNftOrderRefundVo(String orderRefundId, HashMap<String, Object> data) {
        return mongoTemplate.getCollection(GoblinNftOrderRefundVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderRefundId").is(orderRefundId)).getQueryObject(),
                ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data))
        );
    }

    /**
     * 记录用户藏品数据
     */
    public void insertGoblinUserDigitalArtworkVo(GoblinUserDigitalArtworkVo vo) {
        mongoTemplate.insert(vo, GoblinUserDigitalArtworkVo.class.getSimpleName());
    }
}
