package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtGoodsSkuArActionParam", description = "商品管理:藏品AR:管理（删除...）")
@Data
public class GoblinStoreMgtGoodsSkuArActionParam implements Serializable {
    private static final long serialVersionUID = 3193592471744574048L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "操作类型[REMOVE-删除]")
    @Pattern(regexp = "\\b(REMOVE)\\b", message = "操作类型无效")
    private String action;
    @ApiModelProperty(position = 12, required = true, value = "单品ID列表")
    private List<String> skuIdList;
}
