package com.liquidnet.service.platform.controller.partner;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.ChildPerformanceDao;
import com.liquidnet.service.kylin.dto.param.CheckUserParam;
import com.liquidnet.service.kylin.service.partner.IKylinCheckUserPerformancesPartnerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * <p>
 * 验票用户可看演出表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-21
 */
@Api(tags = "第三方-验票账号关联演出")
@RestController
@RequestMapping("partner/checkUser/performance")
@Validated
public class KylinCheckUserPerformancesPartnerController {

    @Autowired
    private IKylinCheckUserPerformancesPartnerService userPerformancesPartnerService;

    @PostMapping(value = "")
    @ApiOperation(value = "添加关联关系", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> setPerformance(@RequestBody @Valid CheckUserParam param) {
        return userPerformancesPartnerService.setPerformance(param);
    }

    @DeleteMapping(value = "")
    @ApiOperation(value = "删除关联关系", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> delPerformance(@RequestParam("performanceIds") @Size(min = 1) @NotNull(message = "演出ID不能为空") List<String> performanceIds,
                                              @RequestParam("checkUserId") String checkUserId) {
        return userPerformancesPartnerService.delPerformance(performanceIds, checkUserId);
    }

    @GetMapping(value = "relation")
    @ApiOperation(value = "关联演出列表", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<ChildPerformanceDao>> childPerformanceList(@RequestParam("merchantId") @NotNull(message = "商户ID不能为空") String merchantId,
                                                                           @RequestParam("checkUserId") @NotNull(message = "验票用户ID不能为空") String checkUserId,
                                                                           @RequestParam("page") @NotNull(message = "页数不能为空") @Min(1) int page,
                                                                           @RequestParam("size") @NotNull(message = "数量不能为空") @Min(1) int size,
                                                                           @RequestParam("name") String name) {
        return userPerformancesPartnerService.childPerformanceList(merchantId, checkUserId, page, size, name);
    }

    @GetMapping(value = "unRelation")
    @ApiOperation(value = "未关联演出列表", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<ChildPerformanceDao>> unChildPerformanceList(@RequestParam("merchantId") @NotNull(message = "商户ID不能为空") String merchantId,
                                                                             @RequestParam("checkUserId") @NotNull(message = "验票用户ID不能为空") String checkUserId,
                                                                             @RequestParam("page") @NotNull(message = "页数不能为空") @Min(1) int page,
                                                                             @RequestParam("size") @NotNull(message = "数量不能为空") @Min(1) int size,
                                                                             @RequestParam("name") String name) {
        return userPerformancesPartnerService.unChildPerformanceList(merchantId, checkUserId, page, size, name);
    }
}
