package com.liquidnet.service.kylin.dto.param.ticketSystem;

import com.liquidnet.service.kylin.dto.vo.ticketSystem.STFieldListVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "STUpdatePerformanceParam", description = "详情")
public class STUpdatePerformanceParam implements Cloneable {
    @ApiModelProperty(value = "演出ID [必传]")
    String performanceId;
    @ApiModelProperty(value = "演出名称 [非必传]")
    String performanceName;
    @ApiModelProperty(value = "演出描述 [非必传]")
    String performanceDesc;
    @ApiModelProperty(value = "演出类型 [非必传]")
    Integer typeId;
    @ApiModelProperty(value = "演出封面图 [非必传]")
    String posterUrl;
    @ApiModelProperty(value = "主办方，多个用英文逗号分隔 [非必传]")
    String sponsor;
    @ApiModelProperty(value = "演员，多个用英文逗号分隔 [非必传]")
    String performer;
    @ApiModelProperty(value = "批文号 [非必传]")
    String approval;

    private static final STUpdatePerformanceParam obj = new STUpdatePerformanceParam();

    public static STUpdatePerformanceParam getNew() {
        try {
            return (STUpdatePerformanceParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new STUpdatePerformanceParam();
    }
}
