package com.liquidnet.client.admin.web.controller.zhengzai.slime;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeSponsorAppliesAdminService;
import com.liquidnet.service.slime.dto.param.admin.SlimeSponsorApplyListParam;
import com.liquidnet.service.slime.dto.vo.SlimeSponsorAppliesVo;
import com.liquidnet.service.slime.entity.SlimeSponsorApplies;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

@Api(tags = "主办申请管理")
@Controller
@RequestMapping("slime/sponsor/apply")
public class SlimeSponsorAppliesController extends BaseController {

    private final String prefix = "zhengzai/kylin/sponsor";

    @Autowired
    ISlimeSponsorAppliesAdminService slimeSponsorAppliesAdminService;

    @RequiresPermissions("slime:sponsor:apply:view")
    @GetMapping()
    public String applyList() {
        return prefix + "/applyList";
    }

    @Log(title = "主办申请管理", businessType = BusinessType.LIST)
    @RequiresPermissions("slime:sponsor:apply:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(SlimeSponsorApplyListParam param) {
        startPage();
        return getDataTable(slimeSponsorAppliesAdminService.list(
                Wrappers.lambdaQuery(SlimeSponsorApplies.class)
                        .eq(param.getSponsorApplyId().length() > 0, SlimeSponsorApplies::getSponsorApplyId, param.getSponsorApplyId())
                        .eq(param.getApplyStatus() >= 0, SlimeSponsorApplies::getApplyStatus, param.getApplyStatus())
                        .select(
                                SlimeSponsorApplies::getSponsorApplyId, SlimeSponsorApplies::getApplyStatus, SlimeSponsorApplies::getApplyType, SlimeSponsorApplies::getReject, SlimeSponsorApplies::getUid,
                                SlimeSponsorApplies::getName, SlimeSponsorApplies::getLogo,
                                SlimeSponsorApplies::getCreatedAt
                        )
        ));
    }

    @Log(title = "主办申请管理", businessType = BusinessType.DETAIL)
    @RequiresPermissions("slime:sponsor:apply:detail")
    @GetMapping(value = "/details/{sponsorApplyId}")
    public String detail(@PathVariable("sponsorApplyId") String sponsorApplyId, ModelMap mmap) {

        LambdaQueryWrapper<SlimeSponsorApplies> sponsorAppliesLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeSponsorApplies.class);
        sponsorAppliesLambdaQueryWrapper.eq(SlimeSponsorApplies::getSponsorApplyId, sponsorApplyId);
        SlimeSponsorApplies sponsorApplies = slimeSponsorAppliesAdminService.getOne(sponsorAppliesLambdaQueryWrapper);

        SlimeSponsorAppliesVo sponsorAppliesVo = SlimeSponsorAppliesVo.getNew();
        sponsorAppliesVo.copy(sponsorApplies);

        mmap.put("sponsorApplyInfo", sponsorAppliesVo);

        return prefix + "/applyDetail";
    }

    @ApiOperation(value = "审核通过")
    @Log(title = "主办申请审核通过", businessType = BusinessType.INSERT)
    @RequiresPermissions("slime:sponsor:apply:approve")
    @PostMapping("/approve")
    @ResponseBody
    public AjaxResult approve(@RequestParam(required = true) String sponsorApplyId) {
        String authUid = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();

        return toAjax(slimeSponsorAppliesAdminService.applyApprove(sponsorApplyId, authUid, authName));
    }

    @ApiOperation(value = "审核驳回")
    @Log(title = "主办申请审核驳回", businessType = BusinessType.INSERT)
    @RequiresPermissions("slime:sponsor:apply:reject")
    @PostMapping("/reject")
    @ResponseBody
    public AjaxResult reject(@RequestParam(required = true) String sponsorApplyId,
                             @RequestParam(required = true) String reject) {
        String authUid = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();

        return toAjax(slimeSponsorAppliesAdminService.applyReject(sponsorApplyId, authUid, authName, reject));
    }
}
