package com.liquidnet.client.admin.zhengzai.slime.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.kylin.service.InnerService;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeCompaniesAdminService;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeFieldAppliesAdminService;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeFieldsAdminService;
import com.liquidnet.client.admin.zhengzai.slime.utils.SlimeMongoUtil;
import com.liquidnet.client.admin.zhengzai.slime.utils.SlimeRedisUtil;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.slime.dto.vo.SlimeCompaniesVo;
import com.liquidnet.service.slime.dto.vo.SlimeFieldAppliesVo;
import com.liquidnet.service.slime.dto.vo.SlimeFieldsVo;
import com.liquidnet.service.slime.entity.SlimeCompanies;
import com.liquidnet.service.slime.entity.SlimeFieldApplies;
import com.liquidnet.service.slime.entity.SlimeFields;
import com.liquidnet.service.slime.mapper.SlimeFieldAppliesMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class SlimeFieldAppliesAdminServiceImpl extends ServiceImpl<SlimeFieldAppliesMapper, SlimeFieldApplies> implements ISlimeFieldAppliesAdminService {

    @Autowired
    InnerService innerService;

    @Autowired
    SlimeRedisUtil slimeRedisUtil;

    @Autowired
    SlimeMongoUtil slimeMongoUtil;

    @Autowired
    MongoTemplate mongoTemplate;


    @Autowired
    ISlimeFieldsAdminService slimeFieldsAdminService;

    @Autowired
    ISlimeCompaniesAdminService slimeCompaniesAdminService;


    @Override
    @Transactional
    public boolean applyApprove(String fieldApplyId, String auditUid, String auditName) {
        LocalDateTime now = LocalDateTime.now();

        // 场地申请 entity
        LambdaQueryWrapper<SlimeFieldApplies> fieldAppliesLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeFieldApplies.class);
        fieldAppliesLambdaQueryWrapper.eq(SlimeFieldApplies::getFieldApplyId, fieldApplyId);
        SlimeFieldApplies fieldAppliesEntity = getOne(fieldAppliesLambdaQueryWrapper);
        if (0 != fieldAppliesEntity.getApplyStatus()) {
            // todo error
            throw new LiquidnetServiceException();
        }

        if (fieldAppliesEntity.getApplyType().equals("claim")) {
            // 认领逻辑

            // 公司 entity mysql
            SlimeCompanies companiesEntity = new SlimeCompanies();
            companiesEntity.setCompanyId(IDGenerator.nextSnowId());
            companiesEntity.setName(fieldAppliesEntity.getCompanyName());
            companiesEntity.setLicenseCode(fieldAppliesEntity.getLicenseCode());
            companiesEntity.setLicenseImg(fieldAppliesEntity.getLicenseImg());
            companiesEntity.setLegalName(fieldAppliesEntity.getLegalName());
            companiesEntity.setLegalIdentity(fieldAppliesEntity.getLegalIdentity());
            companiesEntity.setLegalIdentityObverse(fieldAppliesEntity.getLegalIdentityObverse());
            companiesEntity.setLegalIdentityReverse(fieldAppliesEntity.getLegalIdentityReverse());
            companiesEntity.setCreatedAt(now);
            boolean success = slimeCompaniesAdminService.save(companiesEntity);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地 entity mysql
            LambdaQueryWrapper<SlimeFields> fieldsLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeFields.class);
            fieldsLambdaQueryWrapper.eq(SlimeFields::getFieldId, fieldAppliesEntity.getFieldId());
            SlimeFields fieldsEntity = slimeFieldsAdminService.getOne(fieldsLambdaQueryWrapper);
            if (null == fieldsEntity) {
                // todo error
                throw new LiquidnetServiceException();
            }
            if (2 != fieldsEntity.getClaimStatus() || !fieldsEntity.getUid().equals(fieldAppliesEntity.getUid())) {
                // todo error
                throw new LiquidnetServiceException();
            }
            fieldsEntity.setIsOnline(1);
            fieldsEntity.setClaimStatus(1);
            fieldsEntity.setUid(fieldAppliesEntity.getUid());
            fieldsEntity.setIsCheck(0);
            fieldsEntity.setName(fieldAppliesEntity.getName());
            fieldsEntity.setLogo(fieldAppliesEntity.getLogo());
            fieldsEntity.setBackground(fieldAppliesEntity.getBackground());
            fieldsEntity.setDescription(fieldAppliesEntity.getDescription());
            fieldsEntity.setBuiltDate(fieldAppliesEntity.getBuiltDate());
            fieldsEntity.setProvinceId(fieldAppliesEntity.getProvinceId());
            fieldsEntity.setProvinceName(fieldAppliesEntity.getProvinceName());
            fieldsEntity.setCityId(fieldAppliesEntity.getCityId());
            fieldsEntity.setCityName(fieldAppliesEntity.getCityName());
            fieldsEntity.setDistrictId(fieldAppliesEntity.getDistrictId());
            fieldsEntity.setDistrictName(fieldAppliesEntity.getDistrictName());
            fieldsEntity.setAddress(fieldAppliesEntity.getAddress());
            fieldsEntity.setLongitude(fieldAppliesEntity.getLongitude());
            fieldsEntity.setLatitude(fieldAppliesEntity.getLatitude());
            fieldsEntity.setContactName(fieldAppliesEntity.getContactName());
            fieldsEntity.setContactEmail(fieldAppliesEntity.getContactEmail());
            fieldsEntity.setCompanyId(companiesEntity.getCompanyId());
            fieldsEntity.setUpdatedAt(now);
            LambdaUpdateWrapper<SlimeFields> fieldsLambdaUpdateWrapper = Wrappers.lambdaUpdate(SlimeFields.class);
            fieldsLambdaUpdateWrapper.eq(SlimeFields::getFieldId, fieldsEntity.getFieldId());
            success = slimeFieldsAdminService.update(fieldsEntity, fieldsLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地申请 entity mysql
            fieldAppliesEntity.setApplyStatus(1);
            fieldAppliesEntity.setReject("");
            fieldAppliesEntity.setAuditUid(auditUid);
            fieldAppliesEntity.setAuditName(auditName);
            fieldAppliesEntity.setAuditedAt(now);
            fieldAppliesEntity.setUpdatedAt(now);
            LambdaUpdateWrapper<SlimeFieldApplies> fieldAppliesLambdaUpdateWrapper = Wrappers.lambdaUpdate(SlimeFieldApplies.class);
            fieldAppliesLambdaUpdateWrapper.eq(SlimeFieldApplies::getFieldApplyId, fieldAppliesEntity.getFieldApplyId());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getApplyStatus, fieldAppliesEntity.getApplyStatus());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getReject, fieldAppliesEntity.getReject());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditUid, fieldAppliesEntity.getAuditUid());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditName, fieldAppliesEntity.getAuditName());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditedAt, fieldAppliesEntity.getAuditedAt());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getUpdatedAt, fieldAppliesEntity.getUpdatedAt());
            success = update(fieldAppliesLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 公司 vo
            SlimeCompaniesVo companiesVo = SlimeCompaniesVo.getNew();
            companiesVo.copy(companiesEntity);

            // 场地 vo
            SlimeFieldsVo fieldsVo = SlimeFieldsVo.getNew();
            fieldsVo.copy(fieldsEntity);
            fieldsVo.setCompaniesVo(companiesVo);

            // 场地申请 vo
            SlimeFieldAppliesVo fieldAppliesVo = SlimeFieldAppliesVo.getNew();
            fieldAppliesVo.copy(fieldAppliesEntity);

            // 场地 sync mongo
            slimeMongoUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地 sync redis
            slimeRedisUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地申请 sync mongo
            Query query = Query.query(Criteria.where("fieldApplyId").is(fieldAppliesVo.getFieldApplyId()));
            Update update = Update.update("applyStatus", fieldAppliesVo.getApplyStatus());
            update.set("reject", fieldAppliesVo.getReject());
            update.set("auditUid", fieldAppliesVo.getAuditUid());
            update.set("auditName", fieldAppliesVo.getAuditName());
            update.set("auditedAt", fieldAppliesVo.getAuditedAt());
            update.set("updatedAt", fieldAppliesVo.getUpdatedAt());
            mongoTemplate.updateFirst(query, update, SlimeFieldAppliesVo.class, SlimeFieldAppliesVo.class.getSimpleName());

            // 场地申请 sync redis
            List<SlimeFieldAppliesVo> fieldAppliesVos = slimeRedisUtil.getFieldAppliesVosByUid(fieldAppliesVo.getUid());
            slimeRedisUtil.setFieldAppliesVoByUid(fieldAppliesVo.getUid(), fieldAppliesVos, fieldAppliesVo);
            //上传场地
            innerService.reportField(fieldsVo);
        } else {
            // 创建逻辑

            // 公司 entity mysql
            SlimeCompanies companiesEntity = new SlimeCompanies();
            companiesEntity.setCompanyId(IDGenerator.nextSnowId());
            companiesEntity.setName(fieldAppliesEntity.getCompanyName());
            companiesEntity.setLicenseCode(fieldAppliesEntity.getLicenseCode());
            companiesEntity.setLicenseImg(fieldAppliesEntity.getLicenseImg());
            companiesEntity.setLegalName(fieldAppliesEntity.getLegalName());
            companiesEntity.setLegalIdentity(fieldAppliesEntity.getLegalIdentity());
            companiesEntity.setLegalIdentityObverse(fieldAppliesEntity.getLegalIdentityObverse());
            companiesEntity.setLegalIdentityReverse(fieldAppliesEntity.getLegalIdentityReverse());
            companiesEntity.setCreatedAt(now);
            boolean success = slimeCompaniesAdminService.save(companiesEntity);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地 entity mysql
            SlimeFields fieldsEntity = new SlimeFields();
            fieldsEntity.setFieldId(IDGenerator.nextSnowId());
            fieldsEntity.setIsOnline(1);
            fieldsEntity.setClaimStatus(1);
            fieldsEntity.setUid(fieldAppliesEntity.getUid());
            fieldsEntity.setIsCheck(0);
            fieldsEntity.setName(fieldAppliesEntity.getName());
            fieldsEntity.setLogo(fieldAppliesEntity.getLogo());
            fieldsEntity.setBackground(fieldAppliesEntity.getBackground());
            fieldsEntity.setDescription(fieldAppliesEntity.getDescription());
            fieldsEntity.setBuiltDate(fieldAppliesEntity.getBuiltDate());
            fieldsEntity.setProvinceId(fieldAppliesEntity.getProvinceId());
            fieldsEntity.setProvinceName(fieldAppliesEntity.getProvinceName());
            fieldsEntity.setCityId(fieldAppliesEntity.getCityId());
            fieldsEntity.setCityName(fieldAppliesEntity.getCityName());
            fieldsEntity.setDistrictId(fieldAppliesEntity.getDistrictId());
            fieldsEntity.setDistrictName(fieldAppliesEntity.getDistrictName());
            fieldsEntity.setAddress(fieldAppliesEntity.getAddress());
            fieldsEntity.setLongitude(fieldAppliesEntity.getLongitude());
            fieldsEntity.setLatitude(fieldAppliesEntity.getLatitude());
            fieldsEntity.setContactName(fieldAppliesEntity.getContactName());
            fieldsEntity.setContactEmail(fieldAppliesEntity.getContactEmail());
            fieldsEntity.setCompanyId(companiesEntity.getCompanyId());
            fieldsEntity.setCreatedAt(now);
            success = slimeFieldsAdminService.save(fieldsEntity);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地申请 entity mysql
            fieldAppliesEntity.setApplyStatus(1);
            fieldAppliesEntity.setReject("");
            fieldAppliesEntity.setAuditUid(auditUid);
            fieldAppliesEntity.setAuditName(auditName);
            fieldAppliesEntity.setAuditedAt(now);
            fieldAppliesEntity.setUpdatedAt(now);
            fieldAppliesEntity.setFieldId(fieldsEntity.getFieldId());
            LambdaUpdateWrapper<SlimeFieldApplies> fieldAppliesLambdaUpdateWrapper = Wrappers.lambdaUpdate(SlimeFieldApplies.class);
            fieldAppliesLambdaUpdateWrapper.eq(SlimeFieldApplies::getFieldApplyId, fieldAppliesEntity.getFieldApplyId());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getApplyStatus, fieldAppliesEntity.getApplyStatus());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getReject, fieldAppliesEntity.getReject());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditUid, fieldAppliesEntity.getAuditUid());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditName, fieldAppliesEntity.getAuditName());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditedAt, fieldAppliesEntity.getAuditedAt());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getUpdatedAt, fieldAppliesEntity.getUpdatedAt());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getFieldId, fieldAppliesEntity.getFieldId());
            success = update(fieldAppliesLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 公司 vo
            SlimeCompaniesVo companiesVo = SlimeCompaniesVo.getNew();
            companiesVo.copy(companiesEntity);

            // 场地 vo
            SlimeFieldsVo fieldsVo = SlimeFieldsVo.getNew();
            fieldsVo.copy(fieldsEntity);
            fieldsVo.setCompaniesVo(companiesVo);

            // 场地申请 vo
            SlimeFieldAppliesVo fieldAppliesVo = SlimeFieldAppliesVo.getNew();
            fieldAppliesVo.copy(fieldAppliesEntity);

            // 场地 sync mongo
            slimeMongoUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地 sync redis
            slimeRedisUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地申请 sync mongo
            Query query = Query.query(Criteria.where("fieldApplyId").is(fieldAppliesVo.getFieldApplyId()));
            Update update = Update.update("applyStatus", fieldAppliesVo.getApplyStatus());
            update.set("reject", fieldAppliesVo.getReject());
            update.set("auditUid", fieldAppliesVo.getAuditUid());
            update.set("auditName", fieldAppliesVo.getAuditName());
            update.set("auditedAt", fieldAppliesVo.getAuditedAt());
            update.set("updatedAt", fieldAppliesVo.getUpdatedAt());
            update.set("fieldId", fieldAppliesVo.getFieldId());
            mongoTemplate.updateFirst(query, update, SlimeFieldAppliesVo.class, SlimeFieldAppliesVo.class.getSimpleName());

            // 场地申请 sync redis
            List<SlimeFieldAppliesVo> fieldAppliesVos = slimeRedisUtil.getFieldAppliesVosByUid(fieldAppliesVo.getUid());
            slimeRedisUtil.setFieldAppliesVoByUid(fieldAppliesVo.getUid(), fieldAppliesVos, fieldAppliesVo);
            //上传场地
            innerService.reportField(fieldsVo);
        }

        return true;
    }

    @Override
    public boolean applyReject(String fieldApplyId, String auditUid, String auditName, String reject) {
        LocalDateTime now = LocalDateTime.now();

        // 场地申请 entity
        LambdaQueryWrapper<SlimeFieldApplies> fieldAppliesLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeFieldApplies.class);
        fieldAppliesLambdaQueryWrapper.eq(SlimeFieldApplies::getFieldApplyId, fieldApplyId);
        SlimeFieldApplies fieldAppliesEntity = getOne(fieldAppliesLambdaQueryWrapper);
        if (0 != fieldAppliesEntity.getApplyStatus()) {
            // todo error
            throw new LiquidnetServiceException();
        }

        if (fieldAppliesEntity.getApplyType().equals("claim")) {
            // 驳回认领逻辑

            // 场地 entity mysql
            LambdaQueryWrapper<SlimeFields> fieldsLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeFields.class);
            fieldsLambdaQueryWrapper.eq(SlimeFields::getFieldId, fieldAppliesEntity.getFieldId());
            SlimeFields fieldsEntity = slimeFieldsAdminService.getOne(fieldsLambdaQueryWrapper);
            if (null == fieldsEntity) {
                // todo error
                throw new LiquidnetServiceException();
            }
            if (2 != fieldsEntity.getClaimStatus() || !fieldsEntity.getUid().equals(fieldAppliesEntity.getUid())) {
                // todo error
                throw new LiquidnetServiceException();
            }
            fieldsEntity.setClaimStatus(0);
            fieldsEntity.setUid("");
            fieldsEntity.setUpdatedAt(now);
            LambdaUpdateWrapper<SlimeFields> fieldsLambdaUpdateWrapper = Wrappers.lambdaUpdate(SlimeFields.class);
            fieldsLambdaUpdateWrapper.eq(SlimeFields::getFieldId, fieldsEntity.getFieldId());
            fieldsLambdaUpdateWrapper.set(SlimeFields::getClaimStatus, fieldsEntity.getClaimStatus());
            fieldsLambdaUpdateWrapper.set(SlimeFields::getUid, fieldsEntity.getUid());
            fieldsLambdaUpdateWrapper.set(SlimeFields::getUpdatedAt, fieldsEntity.getUpdatedAt());
            boolean success = slimeFieldsAdminService.update(fieldsLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地申请 entity mysql
            fieldAppliesEntity.setApplyStatus(2);
            fieldAppliesEntity.setReject(reject);
            fieldAppliesEntity.setAuditUid(auditUid);
            fieldAppliesEntity.setAuditName(auditName);
            fieldAppliesEntity.setAuditedAt(now);
            fieldAppliesEntity.setUpdatedAt(now);
            LambdaUpdateWrapper<SlimeFieldApplies> fieldAppliesLambdaUpdateWrapper = Wrappers.lambdaUpdate(SlimeFieldApplies.class);
            fieldAppliesLambdaUpdateWrapper.eq(SlimeFieldApplies::getFieldApplyId, fieldAppliesEntity.getFieldApplyId());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getApplyStatus, fieldAppliesEntity.getApplyStatus());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getReject, fieldAppliesEntity.getReject());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditUid, fieldAppliesEntity.getAuditUid());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditName, fieldAppliesEntity.getAuditName());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditedAt, fieldAppliesEntity.getAuditedAt());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getUpdatedAt, fieldAppliesEntity.getUpdatedAt());
            success = update(fieldAppliesLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地 vo
            SlimeFieldsVo fieldsVo = slimeRedisUtil.getFieldsVoByFieldId(fieldsEntity.getFieldId());
            fieldsVo.setClaimStatus(0);
            fieldsVo.setUid("");
            fieldsVo.setUpdatedAt(now);

            // 场地申请 vo
            SlimeFieldAppliesVo fieldAppliesVo = SlimeFieldAppliesVo.getNew();
            fieldAppliesVo.copy(fieldAppliesEntity);

            // 场地 sync mongo
            slimeMongoUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地 sync redis
            slimeRedisUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地申请 sync mongo
            Query query = Query.query(Criteria.where("fieldApplyId").is(fieldAppliesVo.getFieldApplyId()));
            Update update = Update.update("applyStatus", fieldAppliesVo.getApplyStatus());
            update.set("reject", fieldAppliesVo.getReject());
            update.set("auditUid", fieldAppliesVo.getAuditUid());
            update.set("auditName", fieldAppliesVo.getAuditName());
            update.set("auditedAt", fieldAppliesVo.getAuditedAt());
            update.set("updatedAt", fieldAppliesVo.getUpdatedAt());
            mongoTemplate.updateFirst(query, update, SlimeFieldAppliesVo.class, SlimeFieldAppliesVo.class.getSimpleName());

            // 场地申请 sync redis
            List<SlimeFieldAppliesVo> fieldAppliesVos = slimeRedisUtil.getFieldAppliesVosByUid(fieldAppliesVo.getUid());
            slimeRedisUtil.setFieldAppliesVoByUid(fieldAppliesVo.getUid(), fieldAppliesVos, fieldAppliesVo);
        } else {
            // 驳回创建逻辑

            // 场地申请 entity mysql
            fieldAppliesEntity.setApplyStatus(2);
            fieldAppliesEntity.setReject(reject);
            fieldAppliesEntity.setAuditUid(auditUid);
            fieldAppliesEntity.setAuditName(auditName);
            fieldAppliesEntity.setAuditedAt(now);
            fieldAppliesEntity.setUpdatedAt(now);
            LambdaUpdateWrapper<SlimeFieldApplies> fieldAppliesLambdaUpdateWrapper = Wrappers.lambdaUpdate(SlimeFieldApplies.class);
            fieldAppliesLambdaUpdateWrapper.eq(SlimeFieldApplies::getFieldApplyId, fieldAppliesEntity.getFieldApplyId());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getApplyStatus, fieldAppliesEntity.getApplyStatus());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getReject, fieldAppliesEntity.getReject());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditUid, fieldAppliesEntity.getAuditUid());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditName, fieldAppliesEntity.getAuditName());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getAuditedAt, fieldAppliesEntity.getAuditedAt());
            fieldAppliesLambdaUpdateWrapper.set(SlimeFieldApplies::getUpdatedAt, fieldAppliesEntity.getUpdatedAt());
            boolean success = update(fieldAppliesLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地申请 vo
            SlimeFieldAppliesVo fieldAppliesVo = SlimeFieldAppliesVo.getNew();
            fieldAppliesVo.copy(fieldAppliesEntity);

            // 场地申请 sync mongo
            Query query = Query.query(Criteria.where("fieldApplyId").is(fieldAppliesVo.getFieldApplyId()));
            Update update = Update.update("applyStatus", fieldAppliesVo.getApplyStatus());
            update.set("reject", fieldAppliesVo.getReject());
            update.set("auditUid", fieldAppliesVo.getAuditUid());
            update.set("auditName", fieldAppliesVo.getAuditName());
            update.set("auditedAt", fieldAppliesVo.getAuditedAt());
            update.set("updatedAt", fieldAppliesVo.getUpdatedAt());
            mongoTemplate.updateFirst(query, update, SlimeFieldAppliesVo.class, SlimeFieldAppliesVo.class.getSimpleName());

            // 场地申请 sync redis
            List<SlimeFieldAppliesVo> fieldAppliesVos = slimeRedisUtil.getFieldAppliesVosByUid(fieldAppliesVo.getUid());
            slimeRedisUtil.setFieldAppliesVoByUid(fieldAppliesVo.getUid(), fieldAppliesVos, fieldAppliesVo);
        }

        return true;
    }


}
