alter table galaxy_series_nft_info
    add publish_status varchar(10) null comment 'nft发行状态(-1初始化 0发行中 1发行成功 2发行失败)' after router_type;

alter table galaxy_series_nft_info
    add publish_trade_hash varchar(200) null comment 'nft发行交易hash' after publish_status;

alter table galaxy_series_info modify series_name varchar(30) not null comment '本地系列唯一名称(前缀+skuid)';

alter table galaxy_series_nft_info modify series_name varchar(30) not null comment '本地系列唯一名称(前缀+skuid)';

alter table galaxy_nft_order_fail_log modify series_name varchar(30) not null comment '系列的唯一名称';

alter table galaxy_nft_order_info modify series_name varchar(30) not null comment '系列的唯一名称(前缀+skuid)';

alter table galaxy_nft_trade_info modify series_name varchar(30) not null comment '系列的唯一名称';

-- nft转让新增表galaxy_nft_transfer_info
drop TABLE if exists `galaxy_nft_transfer_info`;
create table galaxy_nft_transfer_info
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    trans_order_id varchar(100) NOT NULL COMMENT '转让订单id',
    nft_id varchar(200)   COMMENT 'nftId',
    user_id varchar(200)  NOT NULL COMMENT '用户ID',
    address varchar(200)   COMMENT '转出方地址',
    receive_user_id varchar(200)  NOT NULL COMMENT '接收者用户id',
    receive_address varchar(200)  NOT NULL COMMENT '接收者地址',
    owner_user_id varchar(200)  COMMENT '拥有者用户id',
    owner_address varchar(200)  COMMENT '拥有者地址',
    transfer_hash varchar(200)  COMMENT '转让hash',
    series_id varchar(200) COMMENT '系列的唯一Id',
    router_type varchar(20)  NOT NULL COMMENT '路由类型(zxinchain、eth、antchain)',
    transfer_status varchar(30)  NOT NULL COMMENT '转让状态(-1初始化 0转让中 1转让成功 2转让失败 )',
    error_code varchar(200)  COMMENT '错误code',
    error_msg varchar(200)   COMMENT '错误信息',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB comment '数字藏品转让信息';
create index gntri_idx_trans_order_id on galaxy_nft_transfer_info (trans_order_id);
create index gntri_idx_user_id on galaxy_nft_transfer_info (user_id);
create index gntri_idx_nft_id on galaxy_nft_transfer_info (nft_id);
