package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.impl.SweetAppletSubMsgServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 小程序订阅消息记录表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-22
 */
@Api(tags = "小程序-订阅消息")
@Slf4j
@Validated
@RestController
@RequestMapping("/appletSubMsg")
public class SweetAppletSubMsgController {

    @Autowired
    private SweetAppletSubMsgServiceImpl subMsgService;

    @GetMapping("send")
    @ApiOperation("发送模版消息")
    public ResponseDto send(
            @RequestParam Integer type,
            @RequestParam String targetId
    ) {
        return subMsgService.sendMsg(type, targetId);
    }

    // 一次订阅 可以多次发 直到用户取消订阅 所以正规做法应该是记录订阅模版 不关联任何推送数据 等推送的时候查是否订阅某模版
    // 然后发送判断失败是用户取消了 删除订阅记录 或者看取消是否有回调 利用回调处理也可
    // 现在的理解有误 已写完 先用
    @PostMapping("create")
    @ApiOperation("添加订阅记录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "openId", value = "openId", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "templateId", value = "templateId 多个用英文逗号分割", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "targetId", value = "演出id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "appletType", value = "1草莓 2五百里 3mdsk 4正在", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "activityType", value = "活动类型", required = true),
    })
    public ResponseDto<Boolean> create(
            @RequestParam() String openId,
            @RequestParam() String templateId,
            @RequestParam() String targetId,
            @RequestParam() Integer appletType,
            @RequestParam() Integer activityType
    ) {
        return subMsgService.create(openId, templateId, targetId, appletType, activityType);
    }


}
