package com.liquidnet.client.admin.zhengzai.candy.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponRuleAdminService;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyMgtCouponAdminService;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamMemberRightsCouponVo;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponInfoDto;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponListParam;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponMemberDto;
import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.entity.CandyCouponRule;
import com.liquidnet.service.candy.entity.CandyMgtCoupon;
import com.liquidnet.service.candy.mapper.CandyCouponMapper;
import com.liquidnet.service.candy.mapper.CandyMgtCouponMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class CandyMgtCouponAdminServiceImpl extends ServiceImpl<CandyMgtCouponMapper, CandyMgtCoupon> implements ICandyMgtCouponAdminService {
    @Autowired
    private CandyMgtCouponMapper candyMgtCouponMapper;
    @Autowired
    private CandyCouponMapper candyCouponMapper;
    @Autowired
    private ICandyCouponRuleAdminService candyCouponRuleAdminService;

    @Autowired
    private RedisUtil redisUtil;

    @Override
    @Transactional
    public boolean saveMgtCouponInfo(CandyCoupon initCoupon, CandyMgtCoupon initMgtCoupon, List<CandyCouponRule> initCouponRuleList) {
        int insertCt = candyCouponMapper.insert(initCoupon);
        insertCt += candyMgtCouponMapper.insert(initMgtCoupon);

        boolean saveBatch = candyCouponRuleAdminService.saveBatch(initCouponRuleList);

        if (insertCt < 2 || !saveBatch) {
            throw new LiquidnetServiceException();
        }


        switch (initCoupon.getExclusive()) {
            case 0:
                break;
            case 1:
                // 同步REDIS:用户端:购买会员详情页:权益列表:权益详情:专享券信息
                List<AdamMemberRightsCouponVo> memberRightsCouponVoList =
                        (List<AdamMemberRightsCouponVo>) redisUtil.get(AdamRedisConst.INFO_MEMBER_RIGHTS_COUPON.concat(initMgtCoupon.getMcouponId()));
                if (CollectionUtils.isEmpty(memberRightsCouponVoList)) {
                    memberRightsCouponVoList = new ArrayList<>();
                }
                Integer eventAmt = initMgtCoupon.getEventAmt();
                for (int i = 0; i < eventAmt; i++) {
                    AdamMemberRightsCouponVo memberRightsCouponVo = AdamMemberRightsCouponVo.getNew();
                    memberRightsCouponVo.setMrightsId(initMgtCoupon.getMcouponId());
                    memberRightsCouponVo.setCouponId(initCoupon.getCouponId());
                    memberRightsCouponVo.setBusiType(initCoupon.getBusiType());
                    memberRightsCouponVo.setCouType(initCoupon.getCouType());
                    memberRightsCouponVo.setTitle(initCoupon.getTitle());
                    memberRightsCouponVo.setLabel(initCoupon.getLabel());
                    memberRightsCouponVo.setNotice(initCoupon.getNotice());
                    memberRightsCouponVo.setValFace(initCoupon.getValFace());
                    memberRightsCouponVo.setValOver(initCoupon.getValOver());
                    memberRightsCouponVo.setValMinus(initCoupon.getValMinus());

                    memberRightsCouponVoList.add(memberRightsCouponVo);
                }
                redisUtil.set(AdamRedisConst.INFO_MEMBER_RIGHTS_COUPON.concat(initMgtCoupon.getMcouponId()), memberRightsCouponVoList);
                break;
        }


        return true;
    }

    @Override
    @Transactional
    public boolean updateMgtCouponInfo(CandyCoupon updateCoupon, CandyMgtCoupon updateMgtCoupon, List<CandyCouponRule> initCouponRuleList) {
        LambdaUpdateWrapper<CandyCoupon> couponLambdaUpdateWrapper = Wrappers.lambdaUpdate(CandyCoupon.class)
                .eq(CandyCoupon::getCouponId, updateCoupon.getCouponId())
                .eq(CandyCoupon::getState, 1)
                .eq(CandyCoupon::getExclusive, 10);
        int updateCt = candyCouponMapper.update(updateCoupon, couponLambdaUpdateWrapper);

        LambdaUpdateWrapper<CandyMgtCoupon> mgtCouponLambdaUpdateWrapper = Wrappers.lambdaUpdate(CandyMgtCoupon.class)
                .eq(CandyMgtCoupon::getMcouponId, updateMgtCoupon.getMcouponId())
                .eq(CandyMgtCoupon::getState, 1);
        updateCt += candyMgtCouponMapper.update(updateMgtCoupon, mgtCouponLambdaUpdateWrapper);


        LambdaUpdateWrapper<CandyCouponRule> couponRuleLambdaUpdateWrapper = Wrappers.lambdaUpdate(CandyCouponRule.class)
                .eq(CandyCouponRule::getCouponId, updateCoupon.getCouponId())
                .eq(CandyCouponRule::getState, 1)
                .set(CandyCouponRule::getState, 2);
        candyCouponRuleAdminService.update(couponRuleLambdaUpdateWrapper);

        if (updateCt < 2 || !candyCouponRuleAdminService.saveBatch(initCouponRuleList)) {
            throw new LiquidnetServiceException();
        }


        switch (updateCoupon.getExclusive()) {
            case 0:
                break;
            case 1:
                // 同步REDIS:用户端:购买会员详情页:权益列表:权益详情:专享券信息
                List<AdamMemberRightsCouponVo> memberRightsCouponVoList =
                        (List<AdamMemberRightsCouponVo>) redisUtil.get(AdamRedisConst.INFO_MEMBER_RIGHTS_COUPON.concat(updateMgtCoupon.getMcouponId()));
                memberRightsCouponVoList.removeIf(r -> r.getCouponId().equals(updateCoupon.getCouponId()));
                Integer eventAmt = updateMgtCoupon.getEventAmt();
                for (int i = 0; i < eventAmt; i++) {
                    AdamMemberRightsCouponVo memberRightsCouponVo = AdamMemberRightsCouponVo.getNew();
                    //memberRightsCouponVo.setMrightsId(initMgtCoupon.getMcouponId());
                    memberRightsCouponVo.setCouponId(updateCoupon.getCouponId());
                    memberRightsCouponVo.setBusiType(updateCoupon.getBusiType());
                    memberRightsCouponVo.setCouType(updateCoupon.getCouType());
                    memberRightsCouponVo.setTitle(updateCoupon.getTitle());
                    memberRightsCouponVo.setLabel(updateCoupon.getLabel());
                    memberRightsCouponVo.setNotice(updateCoupon.getNotice());
                    memberRightsCouponVo.setValFace(updateCoupon.getValFace());
                    memberRightsCouponVo.setValOver(updateCoupon.getValOver());
                    memberRightsCouponVo.setValMinus(updateCoupon.getValMinus());

                    memberRightsCouponVoList.add(memberRightsCouponVo);
                }
                redisUtil.set(AdamRedisConst.INFO_MEMBER_RIGHTS_COUPON.concat(updateMgtCoupon.getMcouponId()), memberRightsCouponVoList);
                break;
        }


        return true;
    }

    @Override
    public List<CandyMgtCouponInfoDto> listForMgtCouponInfoDto(CandyMgtCouponListParam listParam) {
        return candyMgtCouponMapper.selectMultiForMgtCouponInfoDto(listParam);
    }

    @Override
    public List<CandyMgtCouponMemberDto> listForMgtCouponMemberDto(List<String> mrightsIdList) {
        return candyMgtCouponMapper.selectMultiForMgtCouponMemberDto(mrightsIdList);
    }
}
