package com.liquidnet.service.sweet.dto;

import com.liquidnet.service.sweet.entity.SweetManualSort;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel
public class SweetManualAppletDto implements Serializable ,Cloneable{
    @ApiModelProperty("电子手册id")
    private String manualId;
    @ApiModelProperty("演出id")
    private String performancesId;
    @ApiModelProperty("演出标题")
    private String title;
    @ApiModelProperty("场地id")
    private String fieldId;
    @ApiModelProperty("场地名称")
    private String fieldName;
    @ApiModelProperty("城市名称")
    private String cityName;
    @ApiModelProperty("演出开始时间")
    private String timeStart;
    @ApiModelProperty("演出结束时间")
    private String timeEnd;

    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;


    private static final SweetManualAppletDto obj = new SweetManualAppletDto();
    public static SweetManualAppletDto getNew() {
        try {
            return (SweetManualAppletDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetManualAppletDto();
        }
    }
}
