package com.liquidnet.service.consumer.dragon.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.consumer.dragon.receiver.RedisPayReceiver;
import com.liquidnet.service.dragon.constant.DragonConstant;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ConsumerPayRedisStreamConfig
 * @Package com.liquidnet.service.consumer.dragon.config
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/11 14:45
 */
@Configuration
public class ConsumerPayRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    private RedisPayReceiver redisPayReceiver;

    private Subscription buildReceiverSubscription(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), getConsumerName(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.name() + t)),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
    }

    @Bean
    public Subscription subscriptionPay01(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay02(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay03(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 3);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay04(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 4);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay05(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 5);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay06(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 6);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay07(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 7);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay08(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 8);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay09(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 9);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay10(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 10);
        listenerContainer.start();
        return subscription;
    }


    @Bean
    public Subscription subscriptionPay11(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 11);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay12(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 12);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay13(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 13);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay14(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 14);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay15(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 15);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay16(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 16);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay17(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 17);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay18(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 18);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay19(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 19);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay20(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 20);
        listenerContainer.start();
        return subscription;
    }
}
