package com.liquidnet.service.order.service;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.param.ticketSystem.STInsertOrderParam;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.ticketSystem.OrderVo;
import com.liquidnet.service.order.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class InnerService {

    @Value("${liquidnet.service.platform.url}")
    private String platform;
    @Autowired
    DataUtils dataUtils;
    @Autowired
    RedisUtil redisUtil;

    //上报订单
    public boolean reportO(KylinOrderTicketVo vo, String channelName) {
        try {
            STInsertOrderParam insertOrderParam = STInsertOrderParam.getNew();
            insertOrderParam.setOrderId(vo.getOrderTicketsId());
            insertOrderParam.setOrderTime(vo.getTimePay());
            insertOrderParam.setChannelType(1);
            insertOrderParam.setChannelName(channelName);
            insertOrderParam.setTicketNum(vo.getNumber());
            insertOrderParam.setTotalAmount(vo.getPriceActual().multiply(BigDecimal.valueOf(100)).intValue());
            insertOrderParam.setTicketType(1);
            insertOrderParam.setTicketMode(vo.getGetTicketType().equalsIgnoreCase("express") ? 1 : 2);
            insertOrderParam.setAuthMode(dataUtils.getPerformanceIsTrueName(vo.getPerformanceId()) == 1 ? 3 : 1);
            int voucherPrice = vo.getPriceVoucher().multiply(BigDecimal.valueOf(100)).divide(BigDecimal.valueOf(vo.getNumber())).intValue();
            List<OrderVo> orderVos = new ArrayList();
            for (KylinOrderTicketEntitiesVo item : vo.getEntitiesVoList()) {
                OrderVo orderVo = OrderVo.getNew();
                orderVo.setTicketOrderId(item.getOrderTicketEntitiesId());
                orderVo.setPerformanceId(item.getPerformanceId());
                orderVo.setSessionId(item.getTimeId());
                orderVo.setSessionCode(getSessionCode(item.getTimeId()));
                orderVo.setPriceId(getPriceId(item.getTicketId()));
                orderVo.setTicketPrice(vo.getPrice().multiply(BigDecimal.valueOf(100)).intValue());
                orderVo.setTicketId(item.getTicketId());
                orderVo.setTicketOrderAmount(orderVo.getTicketPrice() - voucherPrice);
                orderVos.add(orderVo);
            }
            insertOrderParam.setTicketOrderList(orderVos);
            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Accept", "application/json;charset=UTF-8");
            String resultData = HttpUtil.postRaw(platform + "/platform/st/order/insert", JSON.toJSONString(insertOrderParam), header);
            ResponseDto<Boolean> innerReturnVo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<Boolean>>() {
            });
            return innerReturnVo.getData();
        } catch (Exception e) {
            log.error("[ERROR REPORT ORDER] , {}", e);
            return false;
        }
    }

    //获取SessionCode
    private String getSessionCode(String ticketTimeId) {
        return (String) redisUtil.get(KylinRedisConst.TIMES_SESSION_CODE.concat(ticketTimeId));
    }

    private String getPriceId(String ticketId) {
        return ticketId.concat("01");
    }
}
