package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;

@ApiModel(value = "GoblinStoreMgtNoticeAddParam", description = "店铺管理:公告通知:添加|编辑入参")
@Data
public class GoblinStoreMgtNoticeAddParam implements Serializable {
    private static final long serialVersionUID = 6564996671833040261L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = false, value = "公告ID[编辑时必传]")
    private String noticeId;
    @ApiModelProperty(position = 12, required = true, value = "公告内容", example = "...")
    @NotBlank(message = "公告内容不能为空") @Size(max = 50, message = "公告内容长度限制50个字符")
    private String content;
    @ApiModelProperty(position = 13, required = true, value = "发布时间[yyyy-MM-dd HH:mm:ss]")
    @NotBlank(message = "发布时间不能为空")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "发布时间格式有误")
    private String releaseTime;
    @ApiModelProperty(position = 14, required = true, value = "长期有效[0-否|1-是]", allowableValues = "0,1", example = "1")
    @NotBlank(message = "长期有效参数不能为空")
    @Pattern(regexp = "\\b(0|1)\\b", message = "长期有效参数无效")
    private String longLasting;
    @ApiModelProperty(position = 15, required = false, value = "结束时间，长期有效时无需指定[yyyy-MM-dd HH:mm:ss]")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "结束时间格式有误")
    private String cancellTime;
}
