package com.liquidnet.service.galaxy.router.xuper.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyTrade;
import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterTradeHandler;
import com.liquidnet.service.galaxy.router.xuper.biz.XuperTradeBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyRouterStrategyXuperTradeImpl
 * @Package com.liquidnet.service.galaxy.router.xuper.service
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/27 11:04
 */
@Slf4j
@Component
@StrategyGalaxyRouterTradeHandler(GalaxyEnum.RouterTypeEnum.XUPER)
public class GalaxyRouterStrategyXuperTradeImpl implements IGalaxyRouterStrategyTrade {
    @Autowired
    private XuperTradeBiz xuperTradeBiz;

    @Override
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(GalaxyNftPublishAndBuyReqDto reqDto) {
        return xuperTradeBiz.nftPublishAndBuy(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftBuyResultQueryRespDto> nftBuyResultQuery(GalaxyNftBuyResultQueryReqDto reqDto) {
        return null;
    }

    @Override
    public ResponseDto<GalaxyNftBuyPayResultQueryRespDto> nftBuyPayResultQuery(GalaxyNftBuyPayResultQueryReqDto reqDto) {
        return null;
    }

    @Override
    public ResponseDto<GalaxyNftPublishAndBuyResultQueryRespDto> nftPublishAndBuyResultQuery(GalaxyNftPublishAndBuyResultQueryReqDto reqDto) {
        return xuperTradeBiz.nftPublishAndBuyResultQuery(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftPublishAndBuyRouterBatchQueryRespDto> nftPublishAndBuyResultBatchQuery(GalaxyNftPublishAndBuyRouterBatchQueryReqDto reqDto) {
        return null;
    }

    @Override
    public ResponseDto<GalaxyNftBuyRespDto> nftBuy(GalaxyNftBuyReqDto reqDto) {
        return null;
    }

    @Override
    public ResponseDto<GalaxyNftTransferRespDto> nftTransfer(GalaxyNftTransferReqDto reqDto) {
        return xuperTradeBiz.nftTransfer(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftTransferQueryRespDto> nftTransferQuery(GalaxyNftTransferQueryReqDto reqDto) {
        return xuperTradeBiz.nftTransferQuery(reqDto);
    }
}