package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreGoodsCategoryVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtCategoryService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

@Slf4j
@Service
public class GoblinStoreMgtCategoryServiceImpl implements IGoblinStoreMgtCategoryService {
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinMongoUtils goblinMongoUtils;

    @Override
    public List<GoblinStoreGoodsCategoryVo> list(String storeId) {
        return goblinRedisUtils.getStoreGoodsCategoryVos(storeId);
    }

    @Override
    public void add(String storeId, List<GoblinStoreGoodsCategoryVo> addStoreGoodsCategoryVos, List<GoblinStoreGoodsCategoryVo> storeGoodsCategoryVosCache) {
        goblinMongoUtils.setStoreGoodsCategoryVos(addStoreGoodsCategoryVos);

        if (CollectionUtils.isEmpty(storeGoodsCategoryVosCache)) {
            storeGoodsCategoryVosCache = addStoreGoodsCategoryVos;
        } else {
            storeGoodsCategoryVosCache.addAll(addStoreGoodsCategoryVos);
        }

        goblinRedisUtils.setStoreGoodsCategoryVos(storeId, storeGoodsCategoryVosCache);

        LinkedList<Object[]> initStoreGoodsCategoryObjs = CollectionUtil.linkedListObjectArr();
        addStoreGoodsCategoryVos.forEach(r -> initStoreGoodsCategoryObjs.add(new Object[]{
                r.getStoreId(), r.getCateId(), r.getName(), r.getSort(), r.getGrade(), r.getCatePid(), r.getNeIsbn(), r.getCreatedBy(), r.getCreatedAt()
        }));
        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                SqlMapping.get("goblin_store_goods_category.insert", initStoreGoodsCategoryObjs));
    }

    @Override
    public boolean edit(GoblinStoreGoodsCategoryVo updateStoreGoodsCategoryVo, List<GoblinStoreGoodsCategoryVo> storeGoodsCategoryVosCache) {
        if (goblinMongoUtils.updateStoreGoodsCategoryVo(updateStoreGoodsCategoryVo)) {
            goblinRedisUtils.setStoreGoodsCategoryVos(updateStoreGoodsCategoryVo.getStoreId(), storeGoodsCategoryVosCache);

            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(), SqlMapping.get("goblin_store_goods_category.update",
                            updateStoreGoodsCategoryVo.getName(), updateStoreGoodsCategoryVo.getSort(), updateStoreGoodsCategoryVo.getUpdatedBy(),
                            updateStoreGoodsCategoryVo.getUpdatedAt(), updateStoreGoodsCategoryVo.getStoreId(), updateStoreGoodsCategoryVo.getCateId())
            );
            return true;
        }
        return false;
    }

    @Override
    public boolean del(String uid, String storeId, String cateId) {
        List<GoblinStoreGoodsCategoryVo> storeGoodsCategoryVosCache = goblinRedisUtils.getStoreGoodsCategoryVos(storeId);
        int beforeSize = storeGoodsCategoryVosCache.size();
        storeGoodsCategoryVosCache.removeIf(r -> r.getCateId().equals(cateId));
        int afterSize = storeGoodsCategoryVosCache.size();
        if (beforeSize > afterSize) {
            LocalDateTime now = LocalDateTime.now();
            GoblinStoreGoodsCategoryVo delStoreGoodsCategoryVo = GoblinStoreGoodsCategoryVo.getNew();
            delStoreGoodsCategoryVo.setStoreId(storeId);
            delStoreGoodsCategoryVo.setCateId(cateId);
            delStoreGoodsCategoryVo.setDelFlg("1");
            delStoreGoodsCategoryVo.setUpdatedBy(uid);
            delStoreGoodsCategoryVo.setUpdatedAt(now);
            delStoreGoodsCategoryVo.setDeletedBy(uid);
            delStoreGoodsCategoryVo.setDeletedAt(now);

            if (goblinMongoUtils.updateStoreGoodsCategoryVo(delStoreGoodsCategoryVo)) {
                goblinRedisUtils.setStoreGoodsCategoryVos(storeId, storeGoodsCategoryVosCache);

                queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                        SqlMapping.get("goblin_store_goods_category.remove",
                                uid, now, uid, now, storeId, cateId)
                );
                return true;
            }
        } else {
            log.warn("###店铺商品分类管理:删除:分类不存在[uid={},storeId={},cateId={}]", uid, storeId, cateId);
        }
        return false;
    }
}
