package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.param.SweetLostFoundItemParam;
import com.liquidnet.service.sweet.param.ValidationGroups;
import com.liquidnet.service.sweet.service.ISweetLostFoundItemService;
import com.liquidnet.service.sweet.vo.SweetLostFoundItemVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 失物招领信息Controller
 *
 * @author liquidnet
 * @since 2025-01-18
 */
@RestController
@RequestMapping("/lost-found/item")
@Api(value = "失物招领信息管理", tags = "失物招领信息管理")
@Validated
public class SweetLostFoundItemController {

    @Autowired
    private ISweetLostFoundItemService sweetLostFoundItemService;

    @PostMapping("/publish")
    @ApiOperation("发布失物信息")
    public ResponseDto<Boolean> publishItem(@RequestBody @Validated SweetLostFoundItemParam item) {
        return ResponseDto.success(sweetLostFoundItemService.publishItem(item));
    }

    @PutMapping("/update")
    @ApiOperation("编辑失物信息")
    public ResponseDto<Boolean> updateItem(@RequestBody @Validated({ValidationGroups.Update.class}) SweetLostFoundItemParam item) {
        return ResponseDto.success(sweetLostFoundItemService.editItem(item));
    }

    @DeleteMapping("/delete/{itemId}")
    @ApiOperation("删除失物信息")
    public ResponseDto<Boolean> deleteItem(
            @ApiParam("失物信息ID") @PathVariable Long itemId) {
        return ResponseDto.success(sweetLostFoundItemService.deleteItem(itemId));
    }

    @GetMapping("/detail/{itemId}")
    @ApiOperation("获取失物信息详情")
    public ResponseDto<SweetLostFoundItemVo> getItemDetail(
            @ApiParam("失物信息ID") @PathVariable Long itemId) {
        return ResponseDto.success(sweetLostFoundItemService.getItemDetail(itemId));
    }

    @GetMapping("/list")
    @ApiOperation("获取失物信息列表")
    public ResponseDto<List<SweetLostFoundItemVo>> getItemList(
            @ApiParam("物品类型") @RequestParam(required = false) Integer itemType,
            @ApiParam("演出ID") @RequestParam String performanceId
    ) {
        return ResponseDto.success(sweetLostFoundItemService.getItemList(itemType, performanceId));
    }

}