package com.liquidnet.common.third.xuper;

import com.baidu.xuper.crypto.Hash;
import com.liquidnet.common.third.xuper.config.XuperConfig;
import com.liquidnet.common.third.xuper.constant.XuperEnum;
import com.liquidnet.common.third.xuper.dto.*;
import com.liquidnet.common.third.xuper.exception.XupterException;
import com.liquidnet.common.third.xuper.util.XuperSdkUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestXuperSdkUtil
 * @Package com.liquidnet.common.third.xuper.test
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/20 13:53
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestXuperSdkUtil {
    @Autowired
    private XuperConfig xuperConfig;
    @Autowired
    private XuperSdkUtil xuperSdkUtil;

    private static String creatorMnemonic = "person lucky trophy wall kangaroo body bounce coach unable sister second goat guitar virus tree security acoustic ankle kiss deputy sunny message weapon believe";

    private static String customerMnemonic = "resemble dust palm discover lab improve fix decide blossom economy gadget fit behave win pulp mass chunk rude estate street hurdle chat labor brown";
    //安家宾
    private static String customerMnemonic2 = "soup picture whisper true follow same merit antenna glimpse animal sand kind poverty supreme cost skirt various table tunnel casual kidney rebel unable account";
    //测试 王斐
    private static String customerMnemonic_wangfei = "echo walk term near win claim kangaroo series ecology economy cook loop million grid raise shadow yellow library pact filter rally voice begin ability";

    private static String creatorAddress = "YqsYxgBSP74piDhNQHTjWMH9wXnXxZbt8";
    private static String customerAddress1 = "YGvfJh2PjgYZz3hXu7FFH9VYNfgJQ2TQv";
    private static String customerAddress2 = "TAthqnEuqPS8ijrFG3yYxTXH4EgZQxyYF";
    private static String customerAddress_wangfei = "TRLTrmFX91eNZvhL3QDqHot35iKKPZHz7";


    long assetId = 918386921886035729l;

    @Test
    public void getAccount(){
        //要拉取的区块链账户地址
        String addr = xuperSdkUtil.getAccount(creatorMnemonic).getAddress();
        System.out.println("addr===="+addr);
        String addr1 = xuperSdkUtil.getAccount(customerMnemonic).getAddress();
        System.out.println("addr1===="+addr1);
        String addr2 = xuperSdkUtil.getAccount(customerMnemonic2).getAddress();
        System.out.println("addr2===="+addr2);
        String addr_wangfei = xuperSdkUtil.getAccount(customerMnemonic_wangfei).getAddress();
        System.out.println("addr_wangfei===="+addr_wangfei);
    }
    @Test
    public void test(){
//        byte[] byteArrays = Hash.doubleSha256("百".getBytes());
//        System.out.println(new String(byteArrays));
        Integer time = 1656644857;
        String nowTimeStr = DateUtil.format(new Date(time),DateUtil.Formatter.yyyyMMddHHmmss);
        System.out.println("nowTimeStr==="+nowTimeStr);
    }

    @Test
    public void getImageWidthHeight(){
        String file = "/Users/anjiabin/Downloads/zxl_image_test_001.jpg";
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new FileInputStream(file));
        } catch (IOException e) {
            e.printStackTrace();
        }
        int height = bufferedImage.getHeight();
        int width = bufferedImage.getWidth();
        System.out.println("width=="+width + " height=="+height);
    }

    @Test
    public void testXuperConfig(){
        log.info(xuperConfig.getAppId());
        log.info(xuperConfig.getAccessKeyID());
        log.info(xuperConfig.getSecretAccessKey());
        log.info(xuperConfig.getNftApiUrl());
    }

    /**
     * 000创建数字账户
     */
    @Test
    public void testXuper000CreateAccount(){
        Xuper000CreateAccountReqDto reqDto = Xuper000CreateAccountReqDto.getNew();
        // 创建区块链账户
        Xuper000CreateAccountRespDto respDto = null;
        try {
            XuperResponseDto<Xuper000CreateAccountRespDto> xuperResponseDto = xuperSdkUtil.xuper000CreateAccount(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper000CreateAccountRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper000CreateAccount resp : "+ JsonUtils.toJson(respDto));
        //执行结果
//        {
//            "pubKeyStr": "{\"Curvname\":\"P-256\",\"X\":26900004144763996911563948656450421861897438918108431880582510031552805599402,\"Y\":94599997406045773386654355342143942267529588691485440470001050827093124326536}",
//                "priKeyStr": "{\"Curvname\":\"P-256\",\"X\":26900004144763996911563948656450421861897438918108431880582510031552805599402,\"Y\":94599997406045773386654355342143942267529588691485440470001050827093124326536,\"D\":37550310545913595104324496882710663834766010721178384935047209133379369071036}",
//                "address": "YqsYxgBSP74piDhNQHTjWMH9wXnXxZbt8",
//                "mnemonic": "person lucky trophy wall kangaroo body bounce coach unable sister second goat guitar virus tree security acoustic ankle kiss deputy sunny message weapon believe"
//        }
    }

    /**
     * 001获取访问BOS临时STS凭证
     */
    @Test
    public void testXuper001GetStoken(){
        Xuper001GetStokenReqDto reqDto = Xuper001GetStokenReqDto.getNew();
        // 创建区块链账户
        Xuper001GetStokenRespDto respDto = null;
        try {
            reqDto.setMnemonic(creatorMnemonic);
            XuperResponseDto<Xuper001GetStokenRespDto>  xuperResponseDto = xuperSdkUtil.xuper001GetStoken(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper001GetStokenRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper001GetStoken resp : "+ JsonUtils.toJson(respDto));
    }

    /**
     * 002创造数字资产
     * 注意：上传一次就会生成一个资产id,接口不校验资产唯一
     */
    @Test
    public void testXuper002CreateAsset(){
        Xuper002CreateAssetReqDto reqDto = Xuper002CreateAssetReqDto.getNew();
        // 创建区块链账户
        Xuper002CreateAssetRespDto respDto = null;
        String nftUrl = "bos_v1://xasset-offline/110353/ZXLNFTIMAGE202207131638139778801280.jpg/";
        try {
            reqDto.setMnemonic(creatorMnemonic);
            //资产碎片数量，小于1和大于200000代表不做库存限制
            reqDto.setAmount(100);
            //藏品显示售卖价格，单位为分
            reqDto.setPrice(1000l);
            //资产分类。1：艺术品 2：收藏品 3：门票 4：酒店
            reqDto.setAssetCate(Integer.valueOf(XuperEnum.assetTypeEnum.COLLECTION.getCode()));
            //资产名称，小于30个字节
            reqDto.setTitle("百度超级链-数字藏品-测试20220713-001");
            //资产缩略图。bos上传的图片，格式支持：”jpg”, “jpeg”, “png”, “bmp”, “webp”, “heic”。参数格式bos_v1://{bucket}/{object}/{width}_{height}
            reqDto.setThumb(nftUrl.concat("1000_500"));
            //短文字描述，小于300个字节
            reqDto.setShortDesc(reqDto.getTitle().concat("-短文字描述小于300个字节"));
            //(可选)资产详情介绍长图。bos上传的图片，格式支持：”jpg”, “jpeg”, “png”, “bmp”, “webp”, “heic”。参数格式bos_v1://{bucket}/{object}/{width}_{height}
            reqDto.setImgDesc(nftUrl.concat("1000_500"));
            //资产原始文件。比如图片，图片本身就是资产。格式bos_v1://{bucket}/{object} ，文件大小<10M。文件名采用文件md5值，为了正常展现，需要正确携带文件后缀
            reqDto.setAssetUrl(nftUrl.concat("900_1200"));
            //(可选)长文字描述，小于1200个字节
            reqDto.setLongDesc(reqDto.getTitle().concat("-长文字描述，小于1200个字节"));
            //(可选)资产额外描述信息json字符串。比如标签
            reqDto.setAssetExt("{\"tags\":[\"艺术品\",\"古董\"]} ");
            //(可选)资产组id。用于关联业务层酒店/店铺id
            reqDto.setGroupId(123123l);
            //(可选)业务侧用户标记，必要时请安全处理后设置
            reqDto.setUserId(123123l);
            //(可选)要存证的资产文件sm3散列值，如有多个文件逐个计算hash值后合并计算最终hash值
            reqDto.setFileHash(new String(Hash.doubleSha256(reqDto.getAssetUrl().getBytes())));
            XuperResponseDto<Xuper002CreateAssetRespDto>  xuperResponseDto = xuperSdkUtil.xuper002CreateAsset(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper002CreateAssetRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper002CreateAsset resp : "+ JsonUtils.toJson(respDto));
    }

    /**
     * 003修改未发行的数字资产
     * 注意：已发行的资产不可以修改，错误为 40312	资产状态错误，不允许操作
     */
    @Test
    public void testXuper003AlterAsset(){
        Xuper003AlterAssetReqDto reqDto = Xuper003AlterAssetReqDto.getNew();
        // 创建区块链账户
        Xuper003AlterAssetRespDto respDto = null;
        try {
            reqDto.setAssetId(1710956158450194370l);
            //设置助记词
            reqDto.setMnemonic(creatorMnemonic);
            //资产碎片数量，小于1和大于200000代表不做库存限制
            reqDto.setAmount(100);
            //藏品显示售卖价格，单位为分
            reqDto.setPrice(1000l);
            //资产分类。1：艺术品 2：收藏品 3：门票 4：酒店
            reqDto.setAssetCate(Integer.valueOf(XuperEnum.assetTypeEnum.COLLECTION.getCode()));
            //资产名称，小于30个字节
            reqDto.setTitle("百度超级链-数字藏品-测试20220622-001");
            //资产缩略图。bos上传的图片，格式支持：”jpg”, “jpeg”, “png”, “bmp”, “webp”, “heic”。参数格式bos_v1://{bucket}/{object}/{width}_{height}
            reqDto.setThumb("bos_v1://xasset-trade/100100/md5.jpeg/1000_500");
            //短文字描述，小于300个字节
            reqDto.setShortDesc(reqDto.getTitle().concat("-短文字描述小于300个字节"));
            //(可选)资产详情介绍长图。bos上传的图片，格式支持：”jpg”, “jpeg”, “png”, “bmp”, “webp”, “heic”。参数格式bos_v1://{bucket}/{object}/{width}_{height}
            reqDto.setImgDesc("bos_v1://xasset-trade/100100/md5.jpeg/1000_500");
            //资产原始文件。比如图片，图片本身就是资产。格式bos_v1://{bucket}/{object} ，文件大小<10M。文件名采用文件md5值，为了正常展现，需要正确携带文件后缀
            reqDto.setAssetUrl("bos_v1://xasset-trade/100100/md5.gltf");
            //(可选)长文字描述，小于1200个字节
            reqDto.setLongDesc(reqDto.getTitle().concat("-长文字描述，小于1200个字节"));
            //(可选)资产额外描述信息json字符串。比如标签
            reqDto.setAssetExt("{\"tags\":[\"艺术品\",\"古董\"]} ");
            //(可选)资产组id。用于关联业务层酒店/店铺id
            reqDto.setGroupId(123123l);
            //(可选)业务侧用户标记，必要时请安全处理后设置
            reqDto.setUserId(123123l);
            //(可选)要存证的资产文件sm3散列值，如有多个文件逐个计算hash值后合并计算最终hash值
            reqDto.setFileHash(new String(Hash.doubleSha256(reqDto.getAssetUrl().getBytes())));
            XuperResponseDto<Xuper003AlterAssetRespDto>  xuperResponseDto = xuperSdkUtil.xuper003AlterAsset(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper003AlterAssetRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper003AlterAsset resp : "+ JsonUtils.toJson(respDto));
    }

    /**
     * 004链上发行数字资产
     */
    @Test
    public void testXuper004PublishAsset(){
        Xuper004PublishAssetReqDto reqDto = Xuper004PublishAssetReqDto.getNew();
        // 定义返回结果对象
        Xuper004PublishAssetRespDto respDto = null;
//        long assetId = 171095615845019437l;
//        long assetId = 1532351545249738541l;
        long assetId = 1997357095448588049l;
        try {
            reqDto.setMnemonic(creatorMnemonic);
            reqDto.setAssetId(assetId);
            XuperResponseDto<Xuper004PublishAssetRespDto>  xuperResponseDto = xuperSdkUtil.xuper004PublishAsset(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper004PublishAssetRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper004PublishAsset resp : "+ JsonUtils.toJson(respDto));
    }

    /**
     * 005查询数字商品详情
     */
    @Test
    public void testXuper005QueryAsset(){
        Xuper005QueryAssetReqDto reqDto = Xuper005QueryAssetReqDto.getNew();
        // 定义返回结果对象
        Xuper005QueryAssetRespDto respDto = null;
        long assetId = 2206771595529269009l; //第1个
        assetId = 15486733533687569l; //第2个
        assetId = 2137832444854906641l; //第3个

//        long assetId = 1681769488660410129l; //生产 第1个

        assetId = 918386921886035729l; //测试 第1个
        try {
            reqDto.setAssetId(assetId);
            XuperResponseDto<Xuper005QueryAssetRespDto>  xuperResponseDto = xuperSdkUtil.xuper005QueryAsset(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper005QueryAssetRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper005QueryAsset resp : "+ JsonUtils.toJson(respDto));
    }

    /**
     * 006拉取账户创造资产列表
     */
    @Test
    public void testXuper006ListAssetByAddr(){
        Xuper006ListAssetByAddrReqDto reqDto = Xuper006ListAssetByAddrReqDto.getNew();
        // 定义返回结果对象
        Xuper006ListAssetByAddrRespDto respDto = null;
        try {
            //资产状态。0：全部 1：初试 3：发行中 4：发行成功。默认 0（可选）
            int status = 4;
            //要拉取的区块链账户地址
            String addr = xuperSdkUtil.getAccount(creatorMnemonic).getAddress();
            //要拉取页数，第一页为1
            int page = 1;
            //每页拉取数量，默认20，最大50（可选）
            int limit = 50;
            reqDto.setStatus(status);
            reqDto.setAddr(addr);
            reqDto.setPage(page);
            reqDto.setLimit(limit);

            XuperResponseDto<Xuper006ListAssetByAddrRespDto>  xuperResponseDto = xuperSdkUtil.xuper006ListAssetByAddr(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper006ListAssetByAddrRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper006ListAssetByAddr resp : "+ JsonUtils.toJson(respDto));
    }

    /**
     * 007授予数字商品碎片
     */
    @Test
    public void testXuper007GrantShard(){
        Xuper007GrantShardReqDto reqDto = Xuper007GrantShardReqDto.getNew();
        // 定义返回结果对象
        Xuper007GrantShardRespDto respDto = null;
        long assetId = 2137832444854906641l;

        try {
            reqDto.setMnemonic(creatorMnemonic);
            reqDto.setAssetId(assetId);
            reqDto.setShardId(2l);
            reqDto.setToAddr(xuperSdkUtil.getAccount(customerMnemonic).getAddress());
            reqDto.setToUserId(100000l);
            reqDto.setPrice(1234l);
            XuperResponseDto<Xuper007GrantShardRespDto>  xuperResponseDto = xuperSdkUtil.xuper007GrantShard(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper007GrantShardRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper007GrantShard resp : "+ JsonUtils.toJson(respDto));
    }

    @Test
    public void testXuper008TransferShard(){
        Xuper008TransferShardReqDto reqDto = Xuper008TransferShardReqDto.getNew();
        // 定义返回结果对象
        Xuper008TransferShardRespDto respDto = null;

//        long assetId = 2137832444854906641l;
//        assetId = 2137832444854906641l;

        long shardId = 1l;

        try {
//            reqDto.setMnemonic(customerMnemonic_wangfei);
//            reqDto.setAssetId(assetId);
//            reqDto.setShardId(shardId);
//            reqDto.setToAddr(xuperSdkUtil.getAccount(customerMnemonic).getAddress());
//            reqDto.setToUserId(100000l);
//            reqDto.setPrice(1234l);

//            reqDto.setMnemonic(customerMnemonic);
//            reqDto.setAssetId(assetId);
//            reqDto.setShardId(shardId);
//            reqDto.setToAddr(xuperSdkUtil.getAccount(customerMnemonic2).getAddress());
//            reqDto.setToUserId(100000l);
//            reqDto.setPrice(1234l);

            reqDto.setMnemonic(customerMnemonic_wangfei);
            reqDto.setAssetId(assetId);
            reqDto.setShardId(4l);
            reqDto.setToAddr(xuperSdkUtil.getAccount(customerMnemonic2).getAddress());
            reqDto.setToUserId(100000l);
            reqDto.setPrice(1234l);

            XuperResponseDto<Xuper008TransferShardRespDto>  xuperResponseDto = xuperSdkUtil.xuper008TransferShard(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper008TransferShardRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper008TransferShard resp : "+ JsonUtils.toJson(respDto));
    }

    @Test
    public void testXuper009Consume(){
        Xuper009ConsumeReqDto reqDto = Xuper009ConsumeReqDto.getNew();
        // 定义返回结果对象
        Xuper009ConsumeRespDto respDto = null;
        long assetId = 171095615845019437l;
//        long assetId = 1532351545249738541l;
        try {
//            reqDto.setMnemonic(creatorMnemonic);
//            reqDto.setAssetId(assetId);
            XuperResponseDto<Xuper009ConsumeRespDto>  xuperResponseDto = xuperSdkUtil.xuper009Consume(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper009ConsumeRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper009Consume resp : "+ JsonUtils.toJson(respDto));
    }

    @Test
    public void testXuper010QuerySds(){
        Xuper010QuerySdsReqDto reqDto = Xuper010QuerySdsReqDto.getNew();
        // 定义返回结果对象
        Xuper010QuerySdsRespDto respDto = null;
//        long assetId = 171095615845019437l;
//        assetId = 918386921886035729l;
        long shardId = 4l;
        try {
            reqDto.setAssetId(assetId);
            reqDto.setShardId(shardId);
            XuperResponseDto<Xuper010QuerySdsRespDto>  xuperResponseDto = xuperSdkUtil.xuper010QuerySds(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper010QuerySdsRespDto.class);
            }else{
                log.info("testXuper010QuerySds resp error: "+ JsonUtils.toJson(xuperResponseDto));
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper010QuerySds resp : "+ JsonUtils.toJson(respDto));
    }

    /**
     * 该接口只能查询购买人的地址  创建人不支持
     */
    @Test
    public void testXuper011ListSdsByAddr(){
        //要查询的区块链账户地址
        String addr = xuperConfig.getNftPlatformAddress();
        addr = creatorAddress;
        addr = customerAddress1;
        addr = customerAddress2;
//        addr = "TRLTrmFX91eNZvhL3QDqHot35iKKPZHz7";
        Xuper011ListSdsByAddrReqDto reqDto = Xuper011ListSdsByAddrReqDto.getNew();
        // 定义返回结果对象
        Xuper011ListSdsByAddrRespDto respDto = null;
        try {
            reqDto.setAddr(addr);
            reqDto.setPage(1);
            reqDto.setLimit(50);
            reqDto.setAssetId(assetId);

            XuperResponseDto<Xuper011ListSdsByAddrRespDto> xuperResponseDto = xuperSdkUtil.xuper011ListSdsByAddr(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper011ListSdsByAddrRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper011ListSdsByAddr resp : "+ JsonUtils.toJson(respDto));
    }

    @Test
    public void testXuper012ListSdsByAst(){
        Xuper012ListSdsByAstReqDto reqDto = Xuper012ListSdsByAstReqDto.getNew();
        // 定义返回结果对象
        Xuper012ListSdsByAstRespDto respDto = null;
        //xuper-skuid-003
//        long assetId = 477060752401870637l;
//        assetId = 918386921886035729l; //测试1
        try {
            reqDto.setAssetId(assetId);
            reqDto.setCursor("");
            reqDto.setLimit(20);
            XuperResponseDto<Xuper012ListSdsByAstRespDto>  xuperResponseDto = xuperSdkUtil.xuper012ListSdsByAst(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper012ListSdsByAstRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper012ListSdsByAst resp : "+ JsonUtils.toJson(respDto));
    }

    @Test
    public void testXuper013History(){
        Xuper013HistoryReqDto reqDto = Xuper013HistoryReqDto.getNew();
        // 定义返回结果对象
        Xuper013HistoryRespDto respDto = null;
//        long assetId = 477060752401870637l;
//        assetId = 918386921886035729l; //测试1
        long shardId = 4l;
        try {
            reqDto.setAssetId(assetId);
            reqDto.setShardId(shardId);
            reqDto.setPage(1);
            reqDto.setLimit(20);
            XuperResponseDto<Xuper013HistoryRespDto>  xuperResponseDto = xuperSdkUtil.xuper013History(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper013HistoryRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper013History resp : "+ JsonUtils.toJson(respDto));
    }

    /**
     * 资产冻结操作-谨慎使用
     */
    @Test
    public void testXuper014FreezeAsset(){
//        Xuper014FreezeAssetReqDto reqDto = Xuper014FreezeAssetReqDto.getNew();
//        // 定义返回结果对象
//        Xuper014FreezeAssetRespDto respDto = null;
//        long assetId = 171095615845019437l;
////        long assetId = 1532351545249738541l;
//        try {
//            reqDto.setMnemonic(creatorMnemonic);
//            reqDto.setAssetId(assetId);
//            XuperResponseDto<Xuper014FreezeAssetRespDto>  xuperResponseDto = xuperSdkUtil.xuper014FreezeAsset(reqDto);
//            if(xuperResponseDto.isSuccess()){
//                respDto = xuperResponseDto.getParseData(Xuper014FreezeAssetRespDto.class);
//            }
//        }catch (XupterException e) {
//            log.error("biz error msg "+e.getMessage(),e);
//        }catch (Exception e) {
//            log.error("sys error msg "+e.getMessage(),e);
//        }
//        log.info("testXuper014FreezeAsset resp : "+ JsonUtils.toJson(respDto));
    }

    @Test
    public void testXuper015GetEvidenceInfo(){
        Xuper015GetEvidenceInfoReqDto reqDto = Xuper015GetEvidenceInfoReqDto.getNew();
        // 定义返回结果对象
        Xuper015GetEvidenceInfoRespDto respDto = null;
        long assetId = 171095615845019437l;
//        long assetId = 1532351545249738541l;
        try {
            reqDto.setAssetId(assetId);
            XuperResponseDto<Xuper015GetEvidenceInfoRespDto>  xuperResponseDto = xuperSdkUtil.xuper015GetEvidenceInfo(reqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper015GetEvidenceInfoRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper015GetEvidenceInfo resp : "+ JsonUtils.toJson(respDto));
    }
}
