package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dao.KylinAcitve;
import com.liquidnet.service.kylin.dao.KylinTicketActive;
import com.liquidnet.service.kylin.mapper.KylinAcitveMapper;
import com.liquidnet.service.kylin.mapper.KylinTicketActiveMapper;
import com.liquidnet.service.kylin.service.IKylinAcitveService;
import com.liquidnet.service.kylin.service.IKylinTicketActiveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-12
 */
@Service
public class KylinAcitveServiceImpl extends ServiceImpl<KylinAcitveMapper, KylinAcitve> implements IKylinAcitveService {
    @Autowired
    private KylinAcitveMapper kylinAcitveMapper;
    @Autowired
    private KylinTicketActiveMapper kylinTicketActiveMapper;
    @Autowired
    private IKylinTicketActiveService iKylinTicketActiveService;
    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;

    @Override
    @Transactional
    public boolean addKylinAcitve(KylinAcitve kylinAcitve) {
        kylinAcitve.setActiveId(IDGenerator.nextSnowId());
        kylinAcitve.setCreatedAt(LocalDateTime.now());
        kylinAcitve.setUpdatedAt(LocalDateTime.now());
        kylinAcitve.setDelTag(0);
        //保存活动
        kylinAcitveMapper.insert(kylinAcitve);
        //创建券
        iKylinTicketActiveService.saveBatch(getKylinTicketActive(kylinAcitve.getNumber(),kylinAcitve.getActiveId()));
        return true;
    }

    @Override
    public List<KylinAcitve>  pageKylinAcitve(int pageSize, int pageNumber) {
            PageHelper.startPage(pageNumber, pageSize);
            LambdaQueryWrapper<KylinAcitve> queryWrapper = Wrappers.lambdaQuery(KylinAcitve.class);
            List<KylinAcitve> list=kylinAcitveMapper.selectList(queryWrapper);
            return list;
    }

    public List<KylinTicketActive> getKylinTicketActive(int number,String activeId){
        List<KylinTicketActive> list = new ArrayList<>();
        if(number>0){
            for(int i=0;i<number;i++){
                KylinTicketActive kylinTicketActive=new KylinTicketActive();
                kylinTicketActive.setTicketId(IDGenerator.nextSnowId());
                kylinTicketActive.setActivityId(activeId);
                kylinTicketActive.setCode(IDGenerator.createCodeAz(3, 4, true));
                kylinTicketActive.setState(1);
                kylinTicketActive.setCreatedAt(LocalDateTime.now());
                kylinTicketActive.setUpdatedAt(LocalDateTime.now());
                kylinTicketActive.setDelTag(0);
                list.add(kylinTicketActive);
                //redis 存
                redisDataSourceUtil.getRedisKylinUtil().set(KylinRedisConst.ACTIVE_TICKET_AR_TICKET+kylinTicketActive.getCode(),kylinTicketActive);
            }
            return list;
        }
        return null;
    }

}
