package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.KylinExpressModuleVo;
import com.liquidnet.service.kylin.service.IKylinExpressModuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 快递模板表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-15
 */
@Service
public class KylinExpressModuleServiceImpl implements IKylinExpressModuleService {

    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<KylinExpressModuleVo> expressList() {
        String redisKey = KylinRedisConst.KYLIN_EXPRESS_MODULES;
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            return (List<KylinExpressModuleVo>) obj;
        }
    }
}
