package com.liquidnet.client.admin.zhengzai.smile.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileVTSParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileVolunteersTeamService;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.smile.entity.SmileVolunteersTeam;
import com.liquidnet.service.smile.mapper.SmileVolunteersTeamMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class SmileVolunteersTeamServiceImpl extends ServiceImpl<SmileVolunteersTeamMapper, SmileVolunteersTeam> implements ISmileVolunteersTeamService {

    @Autowired
    SmileVolunteersTeamMapper volunteersTeamMapper;

    @Override
    public TableDataInfo list(SmileVTSParam param) {
        try {
            TableDataInfo rspData = new TableDataInfo();
            PageHelper.startPage(param.getPageNum(), param.getPageSize());
            LambdaQueryWrapper<SmileVolunteersTeam> wrappers = Wrappers.lambdaQuery(SmileVolunteersTeam.class);
            if (param.getTitle() != null && !param.getTitle().equals("")) {
                wrappers.eq(SmileVolunteersTeam::getName, param.getTitle());
            }
            List<SmileVolunteersTeam> data = volunteersTeamMapper.selectList(wrappers);
            rspData.setCode(0);
            rspData.setRows(data);
            rspData.setTotal(data.size());
            return rspData;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public AjaxResult insertData(SmileVolunteersTeam bean) {
        bean.setTeamId(IDGenerator.nextTimeId2());
        int count = volunteersTeamMapper.insert(bean);
        if (count > 0) {
            return AjaxResult.success("添加成功");
        }
        return AjaxResult.error("添加失败");
    }

    @Override
    public AjaxResult updateData(SmileVolunteersTeam bean) {
        LambdaQueryWrapper<SmileVolunteersTeam> wrappers = Wrappers.lambdaQuery(SmileVolunteersTeam.class);
        wrappers.eq(SmileVolunteersTeam::getName, bean.getName());
        List<SmileVolunteersTeam> dataList = volunteersTeamMapper.selectList(wrappers);
        for (SmileVolunteersTeam data : dataList) {
            if (!data.getTeamId().equals(bean.getTeamId()) && data.getName().equals(bean.getName())) {
                return AjaxResult.error("职责组名称重复不可修改");
            }
        }
        int count = volunteersTeamMapper.insert(bean);
        if (count > 0) {
            return AjaxResult.success("添加成功");
        }
        return AjaxResult.error("添加失败");
    }

    @Override
    public SmileVolunteersTeam details(String teamId) {
        LambdaQueryWrapper<SmileVolunteersTeam> wrappers = Wrappers.lambdaQuery(SmileVolunteersTeam.class);
        wrappers.eq(SmileVolunteersTeam::getTeamId, teamId);
        SmileVolunteersTeam data = volunteersTeamMapper.selectOne(wrappers);
        return data;
    }

    @Override
    public AjaxResult search(String title) {
        LambdaQueryWrapper<SmileVolunteersTeam> wrappers = Wrappers.lambdaQuery(SmileVolunteersTeam.class);
        wrappers.select(SmileVolunteersTeam::getTeamId, SmileVolunteersTeam::getName, SmileVolunteersTeam::getIntroduce);
        wrappers.like(SmileVolunteersTeam::getName, title);
        List<SmileVolunteersTeam> beanList = volunteersTeamMapper.selectList(wrappers);
        AjaxResult ajax = new AjaxResult();
        ajax.put("value", beanList);
        return ajax;
    }
}
