package com.liquidnet.service.smile.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 志愿者-志愿者项目表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SmileVolunteersProject implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 活动id
     */
    private String projectId;

    /**
     * 项目名称
     */
    private String title;

    /**
     * 开始时间
     */
    private LocalDateTime timeStart;

    /**
     * 结束时间
     */
    private LocalDateTime timeEnd;

    /**
     * 活动地址
     */
    private String address;

    /**
     * 活动介绍
     */
    private String introduce;

    /**
     * 封面图
     */
    private String img;

    /**
     * 补充字段
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
