package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinNftGoodsDetailSpuInfoVo", description = "NFT商品SPU详情[不包含具体SKU，SKU详情参见'GoblinNftGoodsSkuInfoVo']")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinNftGoodsDetailSpuInfoVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -3869909399504844722L;

    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;

    @ApiModelProperty(position = 12, value = "创作者")
    private String author;
    @ApiModelProperty(position = 13, value = "发行方")
    private String publisher;

    @ApiModelProperty(position = 14, value = "注意事项")
    private String attention;

    private static final GoblinNftGoodsDetailSpuInfoVo obj = new GoblinNftGoodsDetailSpuInfoVo();

    public static GoblinNftGoodsDetailSpuInfoVo getNew() {
        try {
            return (GoblinNftGoodsDetailSpuInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftGoodsDetailSpuInfoVo();
        }
    }

    public GoblinNftGoodsDetailSpuInfoVo copy(GoblinGoodsInfoVo source) {
        if (null == source) return this;
        this.setSpuId(source.getSpuId());
        this.setAuthor(source.getAuthor());
        this.setPublisher(source.getPublisher());
        this.setAttention(source.getAttention());
        return this;
    }

}
