package com.liquidnet.service.consumer.goblin.config;

import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.goblin.receiver.ConsumerGoblinShopCartReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;


@Configuration
public class ConsumerGoblinShopCartStreamConfig {
    @Autowired
    ConsumerGoblinShopCartReceiver consumerGoblinShopCartReceiver;


    private StreamMessageListenerContainer<String, MapRecord<String, String, String>> buildStreamMessageListenerContainer(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        return StreamMessageListenerContainer.create(factory, options);
    }
    /**
     * 购物车
     * @return Subscription
     */
    private Subscription receiveSqlShopCart(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(
                Consumer.from(MQConst.GoblinQueue.GOBLIN_SHOP_CART.getGroup(), MQConst.GoblinQueue.GOBLIN_SHOP_CART.name() + t),
                StreamOffset.create(MQConst.GoblinQueue.GOBLIN_SHOP_CART.getKey(), ReadOffset.lastConsumed()), consumerGoblinShopCartReceiver
        );
    }

    /* -------------------------------------------------------- ｜  */
    @Bean
    public Subscription subscriptionSqlShopCart1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlShopCart(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlShopCart2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlShopCart(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlShopCart3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlShopCart(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlShopCart4(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlShopCart(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

}
