package com.liquidnet.service.kylin.service.impl.admin;


import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dto.param.FieldsParam;
import com.liquidnet.service.kylin.dto.vo.FieldsVo;
import com.liquidnet.service.kylin.mapper.KylinFieldRelationMapper;
import com.liquidnet.service.kylin.mapper.KylinFieldStatusMapper;
import com.liquidnet.service.kylin.mapper.KylinFieldsMapper;
import com.liquidnet.service.kylin.service.admin.KylinFieldsAdminService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;

@Service
public class FieldsAdminServiceImpl  implements KylinFieldsAdminService {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private KylinFieldsMapper fieldsMapper;

    @Autowired
    private KylinFieldStatusMapper kylinFieldStatusMapper;

    @Autowired
    private KylinFieldRelationMapper fieldRelationsMapper;

    /**
     * 创建场地
     * @param fieldsParam
     * @return boolean
     */
    @Override
    @Transactional
    public boolean fieldCreate(FieldsParam fieldsParam) {
        try {
            // 获取 主键id
            String fieldsId = IDGenerator.nextSnowId().toString();
            // 获取 当前时间 -> 创建时间
            LocalDateTime createdAt = LocalDateTime.now();

            // mysql 操作
            fieldsMapper.insert(fieldsParam.getFields(fieldsId,createdAt));
            kylinFieldStatusMapper.insert(fieldsParam.getFieldStatus(fieldsId,createdAt));
            fieldRelationsMapper.insert(fieldsParam.getFieldRelations(fieldsId,createdAt));

            // mongo 操作
            FieldsVo fieldsVo = new FieldsVo();
            BeanUtils.copyProperties(fieldsParam, fieldsVo);
            fieldsVo.setFieldsId(fieldsId);
            fieldsVo.setCreatedAt(createdAt);
            Collection<FieldsVo> insertRst = mongoTemplate.insert(
                    Collections.singletonList(fieldsVo), FieldsVo.class.getSimpleName()
            );

            // redis 操作
            redisUtil.hset("kylin:fields:id", fieldsId, fieldsVo);

            return true;
        } catch (Exception e) {
            return false;
        }
    }
}
