package com.liquidnet.service.consumer.kylin.service.processor;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.OrderCloseMapping;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.consumer.kylin.Utils.KylinUtils;
import com.liquidnet.service.consumer.service.IBaseDao;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.amqp.core.Message;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * ConsumerProcessor.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2021/4/29
 */
@Slf4j
@Component
public class ConsumerProcessor {
    @Resource
    IBaseDao baseDao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private KylinUtils kylinUtils;


    private void consumerSqlDaoHandler(Message msg, Channel channel) {
        MessageProperties properties = msg.getMessageProperties();
        String consumerQueue = properties.getConsumerQueue();
        long deliveryTag = properties.getDeliveryTag();
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            if (rstBatchSqls) {
                channel.basicAck(deliveryTag, false);
            } else {
                log.warn("###CONSUMER SQL[consumerQueue:{},deliveryTag={},sqlMessage:{}]", consumerQueue, deliveryTag, JsonUtils.toJson(sqlMessage));
                channel.basicAck(deliveryTag, false);
            }
        } catch (IOException e) {
            log.error("CONSUMER SQL[consumerQueue:{},deliveryTag:{},sqlMessage:{}]", consumerQueue, deliveryTag, JsonUtils.toJson(sqlMessage), e);
        }
    }

    // 处理长sql语句
    private void consumerOperationOrderClose(Message msg, Channel channel) {
        MessageProperties properties = msg.getMessageProperties();
        String consumerQueue = properties.getConsumerQueue();
        long deliveryTag = properties.getDeliveryTag();
        String jsonStr = StringEscapeUtils.unescapeJava(new String(msg.getBody()));
        OrderCloseMapping.orderCloseMessage mqMessage = JsonUtils.fromJson(jsonStr.substring(1, jsonStr.length() - 1), OrderCloseMapping.orderCloseMessage.class);
        try {
            for (int x = 0; x< mqMessage.getOrderTicketIds().size(); x++) {
                String t = mqMessage.getOrderTicketIds().get(x);
                String orderTicketId = t.split(",")[0];
                String uid = t.split(",")[1];
                KylinOrderTicketVo vo = kylinUtils.getOrderTicketVo(orderTicketId);
                vo.setStatus(2);
                redisUtil.set("kylin:order:id:" + orderTicketId, vo);

                kylinUtils.resetOrderListVo(uid, 2, orderTicketId, vo);
                // redis 限购
                for (int i = 0; i < vo.getEntitiesVoList().size(); i++) {
                    KylinOrderTicketEntitiesVo items = vo.getEntitiesVoList().get(i);
                    kylinUtils.changeBuyInfo(items.getUserId(), items.getEnterIdCode(), items.getPerformanceId(), items.getTicketId(), -1);
                }
            }
            channel.basicAck(deliveryTag, false);
        } catch (Exception e) {
            log.error("CONSUMER SQL[consumerQueue:{},deliveryTag:{},sqlMessage:{}]", consumerQueue, deliveryTag, JsonUtils.toJson(mqMessage), e);
        }
    }

    // 验票更新
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EX_LNS_SQL_STATION), key = MQConst.RK_SQL_STATION,
            value = @Queue(MQConst.QUEUES_SQL_STATION)
    ))
    public void consumerSqlForStation(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 订单创建
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate1(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate2(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate3(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate4(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate5(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate6(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate7(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate8(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE), key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate9(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 订单再次支付
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_AGAIN), key = MQConst.ROUTING_KEY_SQL_ORDER_AGAIN,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_AGAIN)
    ))
    public void consumerOrderPayAgain(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 订单关闭
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose(Message msg, Channel channel) {
        this.consumerOperationOrderClose(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose1(Message msg, Channel channel) {
        this.consumerOperationOrderClose(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose2(Message msg, Channel channel) {
        this.consumerOperationOrderClose(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose3(Message msg, Channel channel) {
        this.consumerOperationOrderClose(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose4(Message msg, Channel channel) {
        this.consumerOperationOrderClose(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose5(Message msg, Channel channel) {
        this.consumerOperationOrderClose(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose6(Message msg, Channel channel) {
        this.consumerOperationOrderClose(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose7(Message msg, Channel channel) {
        this.consumerOperationOrderClose(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose8(Message msg, Channel channel) {
        this.consumerOperationOrderClose(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE), key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose9(Message msg, Channel channel) {
        this.consumerOperationOrderClose(msg, channel);
    }


    // 订单支付
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay1(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay2(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay3(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay4(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay5(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay6(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay7(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay8(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay9(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY), key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))

    // 缺票登记
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_PERFORMANCE_LACK), key = MQConst.ROUTING_KEY_SQL_PERFORMANCE_LACK,
            value = @Queue(MQConst.QUEUES_SQL_PERFORMANCE_LACK)
    ))
    public void consumerPerformanceLack(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 申请退款
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_REFUND), key = MQConst.ROUTING_KEY_SQL_ORDER_REFUND,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_REFUND)
    ))
    public void consumerOrderRefund(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_REFUND), key = MQConst.ROUTING_KEY_SQL_ORDER_REFUND,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_REFUND)
    ))
    public void consumerOrderRefund1(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_REFUND), key = MQConst.ROUTING_KEY_SQL_ORDER_REFUND,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_REFUND)
    ))
    public void consumerOrderRefund2(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_REFUND), key = MQConst.ROUTING_KEY_SQL_ORDER_REFUND,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_REFUND)
    ))
    public void consumerOrderRefund3(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_REFUND), key = MQConst.ROUTING_KEY_SQL_ORDER_REFUND,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_REFUND)
    ))
    public void consumerOrderRefund4(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 申请退款撤回
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_WITHDRAW), key = MQConst.ROUTING_KEY_SQL_ORDER_WITHDRAW,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_WITHDRAW)
    ))
    public void consumerOrderRefundWithDraw(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_WITHDRAW), key = MQConst.ROUTING_KEY_SQL_ORDER_WITHDRAW,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_WITHDRAW)
    ))
    public void consumerOrderRefundWithDraw1(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_WITHDRAW), key = MQConst.ROUTING_KEY_SQL_ORDER_WITHDRAW,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_WITHDRAW)
    ))
    public void consumerOrderRefundWithDraw2(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_WITHDRAW), key = MQConst.ROUTING_KEY_SQL_ORDER_WITHDRAW,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_WITHDRAW)
    ))
    public void consumerOrderRefundWithDraw3(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_WITHDRAW), key = MQConst.ROUTING_KEY_SQL_ORDER_WITHDRAW,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_WITHDRAW)
    ))
    public void consumerOrderRefundWithDraw4(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }

    // 超时支付申请退款
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_OVERTIME_REFUND), key = MQConst.ROUTING_KEY_SQL_ORDER_OVERTIME_REFUND,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_OVERTIME_REFUND)
    ))
    public void consumerOrderOvertimeRefund(Message msg, Channel channel) {
        this.consumerSqlDaoHandler(msg, channel);
    }
}
