package com.liquidnet.service.bank.currencycloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * currency cloud conversion param
 */
@Data
@ApiModel(description = "currency cloud rate dto")
public class BankCcRateDto {
    private Date settlementCutOffTime;

    private List<String> currencyPair;

    private String clientBuyCurrency;

    private String clientSellCurrency;

    private BigDecimal clientBuyAmount;

    private BigDecimal clientSellAmount;

    private String fixedSide;

    private BigDecimal midMarketRate;

    private BigDecimal coreRate;

    private BigDecimal partnerRate;

    private BigDecimal clientRate;

    private Boolean depositRequired;

    private BigDecimal depositAmount;

    private String depositCurrency;

    private Date conversionDate;

}
