package com.liquidnet.service.reconciliation.service.core.impl;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.reconciliation.service.core.BuildNoService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 生成编号service实现类,每个编号前面都会有一个前缀用来方便区分是那种编号
 */
@Service("buildNoService")
public class BuildNoServiceImpl implements BuildNoService {

	private static final Log LOG = LogFactory.getLog(BuildNoServiceImpl.class);

	/** 对账批次号前缀 **/
	private static final String RECONCILIATION_BATCH_NO = "_BATCH_";

	/** 获取对账批次号 **/
	public String buildReconciliationNo(String bankChannelCode) {
//		String batchNo = bankChannelCode + RECONCILIATION_BATCH_NO + DateUtil.format(new Date(),DateUtil.Formatter.yyyyMMddHHmmssTrim) + "_" + System.currentTimeMillis();
		String batchNo = bankChannelCode + RECONCILIATION_BATCH_NO + DateUtil.format(new Date(),DateUtil.Formatter.yyyyMMddHHmmssTrim);
		return batchNo;
	}
}